﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using ClipClop.User;
using System.Diagnostics;

namespace ClipClop.View
{
    class TemplateSettingTreeView : TreeView
    {
		private ImageList imageList_;
		private System.ComponentModel.IContainer components;

		public TemplateSettingTreeView()
		{
			InitializeComponent();

			this.ImageList = imageList_;
		}

		enum ImageListItem
		{
			eRoot,
			eSplitter,
			eTemplate,
			eFolder,
			eExecute,
			eEdit,
			eHistory,
		}

		/// <summary>
		/// データをセットする。
		/// </summary>
		/// <param name="doc"></param>
		/// <see cref="http://www.atmarkit.co.jp/fdotnet/dotnettips/259treeviewadd/treeviewadd.html"/>
		/// <see cref="http://wawatete.ddo.jp/exec/program/cs/xml_xmltreeview"/>
		public void Setup(XmlDocument doc)
		{
			this.Nodes.Clear();

			//TODO ○多量の場合を考慮する？
			XmlNode root = ContextMenuSettingHelper.GetRoot( doc );
			if (root == null)
				return;

			TemplateSettingTreeNode treeNode = new TemplateSettingTreeNode(root.Name, (int)ImageListItem.eRoot, (int)ImageListItem.eRoot, root);
			int index = this.Nodes.Add(treeNode);

			RecursiveShowToTreeNode(root, treeNode);

			this.ExpandAll();
			this.SelectedNode = treeNode;
		}

		static ImageListItem GetImageItem(XmlNode node)
		{
			if (ContextMenuSettingDefinition.Sentence_ == node.Name)
			{
				ContextMenuSettingDefinition.Mode mode = ContextMenuSettingHelper.GetMode(node);

				switch (mode)
				{
					case ContextMenuSettingDefinition.Mode.template:
						return ImageListItem.eTemplate;
					case ContextMenuSettingDefinition.Mode.execute:
						return ImageListItem.eExecute;
					case ContextMenuSettingDefinition.Mode.editfile:
						return ImageListItem.eEdit;
					case ContextMenuSettingDefinition.Mode.clipboardhistory:
						return ImageListItem.eHistory;
				}
				Debug.Fail("ここにはこないはず");
			}

			if( ContextMenuSettingDefinition.Folder_ == node.Name)
			{
				return ImageListItem.eFolder;
			}

			return ImageListItem.eSplitter;
		}

		static void RecursiveShowToTreeNode(XmlNode parentnode, TreeNode parenttreeNode)
		{
			foreach (XmlNode childXmlNode in parentnode.ChildNodes)
			{
				// TreeNodeを新規作成
				int item = (int)GetImageItem(childXmlNode);
				TemplateSettingTreeNode tn = new TemplateSettingTreeNode(
													ContextMenuSettingHelper.GetDisplayString(childXmlNode)
													, item
													, item
													, childXmlNode
												);

				// ノードを追加
				parenttreeNode.Nodes.Add(tn);
				// 再帰呼び出し
				RecursiveShowToTreeNode(childXmlNode, tn);
			}
		}

		public void AppendChild(XmlNode xmlNode)
		{
			if (this.SelectedNode == null)
				return;

			TemplateSettingTreeNode selected = this.SelectedNode as TemplateSettingTreeNode;

			int item = (int)GetImageItem(xmlNode);

			selected.AppendChild(xmlNode, item);
		}

		public void DeleteNode()
		{
			if (this.SelectedNode == null)
				return;

			TemplateSettingTreeNode selected = this.SelectedNode as TemplateSettingTreeNode;

			selected.DeleteNode();
		}

		public XmlNode CopySelectedNode()
		{
			if (this.SelectedNode == null)
				return null;

			TemplateSettingTreeNode selected = this.SelectedNode as TemplateSettingTreeNode;

			return selected.CopyXmlNode();
		}

		

		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TemplateSettingTreeView));
			this.imageList_ = new System.Windows.Forms.ImageList(this.components);
			this.SuspendLayout();
			// 
			// imageList_
			// 
			this.imageList_.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList_.ImageStream")));
			this.imageList_.TransparentColor = System.Drawing.Color.Transparent;
			this.imageList_.Images.SetKeyName(0, "status.png");
			this.imageList_.Images.SetKeyName(1, "ui-splitter.png");
			this.imageList_.Images.SetKeyName(2, "edit.png");
			this.imageList_.Images.SetKeyName(3, "folders-stack.png");
			this.imageList_.Images.SetKeyName(4, "application.png");
			this.imageList_.Images.SetKeyName(5, "EditTableHS.png");
			this.imageList_.Images.SetKeyName(6, "paste.png");
			this.ResumeLayout(false);

		}



    }
}
