﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace ClipClop.User
{
	public abstract class Util
	{
		public static void ShowError(string msg)
		{
			MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
		}

		public static void ShowWarn(string msg)
		{
			MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Warning);
		}

		public static bool Confirm(string msg)
		{
			DialogResult ret = MessageBox.Show(msg, Application.ProductName, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
			if (ret == DialogResult.Yes)
				return true;
			return false;
		}

        public static string MakeFileName(string input)
        {
            char[] invalidChars = Path.GetInvalidFileNameChars();

            foreach (char c in invalidChars)
            {
                while (true)
                {
                    int n = input.IndexOf(c);
                    if (n < 0)
                        break;
                    input = input.Remove(n, 1);
                }
            }
            return input.Length < 255 ? input : input.Substring(0, 255);
        }

	}
}
