﻿using ClipClop.User;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Xml;
using System;

namespace TestProjectClipClop
{
    
    
    /// <summary>
    ///ContextMenuSettingHelperTest のテスト クラスです。すべての
    ///ContextMenuSettingHelperTest 単体テストをここに含めます
    ///</summary>
	[TestClass()]
	public class ContextMenuSettingHelperTest
	{

		XmlDocument document_;

		DateTime testDate1_;
		DateTime testDate2_;


		private TestContext testContextInstance;

		/// <summary>
		///現在のテストの実行についての情報および機能を
		///提供するテスト コンテキストを取得または設定します。
		///</summary>
		public TestContext TestContext
		{
			get
			{
				return testContextInstance;
			}
			set
			{
				testContextInstance = value;
			}
		}

		#region 追加のテスト属性
		// 
		//テストを作成するときに、次の追加属性を使用することができます:
		//
		//クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
		//[ClassInitialize()]
		//public static void MyClassInitialize(TestContext testContext)
		//{
		//}
		//
		//クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
		//[ClassCleanup()]
		//public static void MyClassCleanup()
		//{
		//}
		//
		//各テストを実行する前にコードを実行するには、TestInitialize を使用
		[TestInitialize()]
		public void MyTestInitialize()
		{
			document_ = new XmlDocument();
			testDate1_ = new DateTime(2009, 1, 2, 3, 4, 5);
			testDate2_ = new DateTime(2010, 11, 12, 13, 14, 15);
		}
		//
		//各テストを実行した後にコードを実行するには、TestCleanup を使用
		//[TestCleanup()]
		//public void MyTestCleanup()
		//{
		//}
		//
		#endregion


		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"),TestMethod()]
		public void GetValueReplacedTest001()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"hoge value");

			string expected = "hoge value"; 
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, DateTime.Now);
			Assert.AreEqual(expected, actual);
		}	

		/// <summary>
		///GetValueReplaced のテスト
		///日付 YY/MM/DD			\x
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest002()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\x");

			string expected = "9/1/2";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "10/11/12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///日付 YY/MM/DD			\0x
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest003()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0x");

			string expected = "09/01/02";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "10/11/12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///平成XX年YY月ZZ日		\g年\m月\d日
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest004()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\g年\m月\d日");

			string expected = "平成21年01月02日";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "平成22年11月12日";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///月 January～December		\B
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest005()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\B");

			string expected = "January";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "November";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}


		/// <summary>
		///GetValueReplaced のテスト
		///曜日 日～土			\w
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest006()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\w");

			string expected = "金";// 2009/01/02
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "金"; // 2010/11/12
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///曜日 Sunday～Saturday		\A
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest007()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\A");

			string expected = "Friday";// 2009/01/02
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "Friday"; // 2010/11/12
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///時刻（24時間）23:59:00		\X
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest008()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\X");

			string expected = "03:04:05";// 3:4:5
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "13:14:15"; // 13:14:15
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///\\Xが\Xになること
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest008_1()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\X");

			string expected = @"\X";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);
		}


		/// <summary>
		///GetValueReplaced のテスト
		///時刻（12時間）10:12:30 AM	\r
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest009()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\r");

			string expected = "03:04:05 AM";// 3:4:5 
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "01:14:15 PM"; // 13:14:15
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///YY/MM/DD HH:MM:SS		\x \X
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest010()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\x \X");

			string expected = "9/1/2 03:04:05";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "10/11/12 13:14:15"; // 13:14:15
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///YY/MM/DD(WW) HH:MM:SS		\x(\w) \X
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest011()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\x(\w) \X");

			string expected = "9/1/2(金) 03:04:05";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "10/11/12(金) 13:14:15"; // 13:14:15
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}


		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\Y");

			string expected = "2009";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "2010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012_1()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\Y\Y");

			string expected = "20092009";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "20102010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012_2()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\Y\\Y");

			string expected = @"2009\Y";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = @"2010\Y";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}


		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012_3()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\Y\Y");

			string expected = @"\Y2009";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = @"\Y2010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012_4()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\Yaa\Y");

			string expected = @"\Yaa2009";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = @"\Yaa2010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest012_5()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\Ya\Y");

			string expected = @"2009a2009";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = @"2010a2010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);


			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"a\Y\Y");
			expected = @"a20102010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\Y\Ya");
			expected = @"20102010a";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"a\Y\0m");
			expected = @"a201011";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);


			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"a\0m\Y");
			expected = @"a112010";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);	
		}


		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest013()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0m");

			string expected = "01";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "11";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest014()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d");

			string expected = "02";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest014_1()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\0d");

			string expected = @"\0d";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest014_2()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d\0d");

			string expected = "0202";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "1212";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}

		/// <summary>
		///GetValueReplaced のテスト
		///</summary>
		[Description("文字列置き換え処理の確認"), TestMethod()]
		public void GetValueReplacedTest014_3()
		{
			XmlElement node = document_.CreateElement(ContextMenuSettingDefinition.Sentence_);
			node.SetAttribute(ContextMenuSettingDefinition.Type_, ContextMenuSettingDefinition.Mode.template.ToString());
			node.SetAttribute(ContextMenuSettingDefinition.Name_, "hoge");
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0da\0d");

			string expected = "02a02";
			string actual;
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate1_);
			Assert.AreEqual(expected, actual);

			expected = "12a12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\0da\0d");
			expected = @"\0da12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\\0da\0d");
			expected = @"\12a12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\\\\0da\0d");
			expected = @"\\0da12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d\\Y\0d");
			expected = @"12\Y12";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d\\\Y\0d");
			expected = @"12\201012";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d\Y\0d\");
			expected = @"12201012\";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);

			//
			node.SetAttribute(ContextMenuSettingDefinition.Value_, @"\0d\Y\0d\\");
			expected = @"12201012\";
			actual = ContextMenuSettingHelper.GetValueReplaced(node, testDate2_);
			Assert.AreEqual(expected, actual);
		}
	}
}
