﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using ClipClop.Properties;

namespace ClipClop.User
{
	/// <summary>
	/// 定型文定義XMLファイルの文字列定義（要素名と属性名、それらの値）
	/// </summary>
	public abstract class ContextMenuSettingDefinition
	{
		public enum Mode
		{
			/// <summary>
			/// 定型テキスト
			/// </summary>
			template,

			/// <summary>
			/// テキスト保管...現状未対応
			/// </summary>
			//textfile,

			/// <summary>
			/// アプリケーション実行
			/// </summary>
			execute,

			/// <summary>
			/// クリップボード履歴
			/// </summary>
			clipboardhistory,

			/// <summary>
			/// メニュー定義ファイルの編集
			/// </summary>
			editfile,
		}

		//enumと文字列の対応表
		public static readonly KeyValuePair<string, Mode>[] ModeNamestrings 
			= new KeyValuePair<string, Mode>[] 
			{
				new KeyValuePair<string, Mode>( global::ClipClop.Properties.Resources.CmbTemplate, Mode.template ),
				//new KeyValuePair<string, Mode>( global::ClipClop.Properties.Resources.CmbTextfile, Mode.textfile ),
				new KeyValuePair<string, Mode>( global::ClipClop.Properties.Resources.CmbExecute, Mode.execute ),
				new KeyValuePair<string, Mode>( global::ClipClop.Properties.Resources.CmbClipboardhistory, Mode.clipboardhistory ),
				new KeyValuePair<string, Mode>( global::ClipClop.Properties.Resources.CmbEditfile, Mode.editfile )
			};


		public const string Root_ = "root";

		public enum SettingType
		{
			sentence,
			folder,
			separator,
		}

		public static readonly string Separator_ = SettingType.separator.ToString();
		public static readonly string Folder_ = SettingType.folder.ToString();
		public static readonly string Sentence_ = SettingType.sentence.ToString();

		public const string Image_ = "image";
		public const string Name_ = "name";
		public const string Value_ = "value";
		public const string Type_ = "type";


		/// <summary>
		/// 定型文定義XMLファイルのバージョン
		/// </summary>
		public const int CurrnetVersion = 0x00080000;//初期フォーマット

		/// <summary>
		/// 定型文定義XMLファイルであることの証明をする文字列
		/// </summary>
		public const string MagicNumber = "Heizaemon";

		/// <summary>
		/// root要素の属性
		/// </summary>
		public enum RootAttribute
		{
			version,
			magicnumber,
			encryption,
		}

		public static string GetCurrentVersion()
		{
			return string.Format("0x{0:X8}", ContextMenuSettingDefinition.CurrnetVersion);
		}

		public static string GetXsdFilePath()
		{
			return Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), Settings.Default.XsdFileName);
		}

	}
}
