﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.ComponentModel;
using System.Runtime.Serialization;
using System.Xml.Serialization;
using ClipClop.View;
using CaLib.User.PropertyGridUtil;
using System.Diagnostics;
using System.Drawing;

using ClipClop.Properties;

namespace ClipClop.Model
{
	/// <summary>
	/// User設定
	/// </summary>
	/// <see cref="http://www.atmarkit.co.jp/fdotnet/dotnettips/291pgridjapan/pgridjapan.html"/>
	[TypeConverter(typeof(PropertyDisplayConverter))]
	public class AplSetting
	{
		//TODO ○最小最大入力チェック

		#region ホットキー
		/// <summary>
		/// ホットキー種別
		/// </summary>
		public enum Hotkeys
		{
			Active,
			DeleteHistory,
			TemplatePopup,
		}

		/// <summary>
		/// EXEをアクティブにするホットキー
		/// </summary>
        [DisplayNameLocalized(typeof(Resources), "PGDisplayNameOpenHistory"),
        CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHotkey")]
		public System.Windows.Forms.Keys hkActive_ { get; set; }

		/// <summary>
		/// 履歴を一個削除するホットキー
		/// </summary>
        [DisplayNameLocalized(typeof(Resources), "PGDisplayNameDeleteHistory"),
        CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHotkey")]
        public System.Windows.Forms.Keys hkDeleteHistory_ { get; set; }

		/// <summary>
		/// 定型文メニューを表示するホットキー
		/// </summary>
        [DisplayNameLocalized(typeof(Resources), "PGDisplayNameTemplatePopup"),
        CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHotkey")]
        public System.Windows.Forms.Keys hkTemplatePopup_ { get; set; }
		#endregion

		#region 履歴
        [DisplayNameLocalized(typeof(Resources), "PGDisplayNameMinimizeOnStart"),
        DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionMinimizeOnStart"),
        CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public bool bMinimizeOnStart_ { get; set; }

		/// <summary>
		/// 保持する履歴の上限
		/// </summary>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameMaxHistory"),
		DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionMaxHistory"),
		CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public int maxHistory_ { get; set; }

		/// <summary>
		/// 前回の履歴を引き継ぐかどうか
		/// </summary>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameInheritHistory"),
		DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionInheritHistory"),
		CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public bool bInheritHistory_ { get; set; }

		/// <summary>
		/// 最前面に表示
		/// </summary>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameAlwaysTop"),
		DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionAlwaysTop"),
		CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public bool bAlwaysTop_ { get; set; }

		/// <summary>
		/// フォームの透明度
		/// </summary>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameOpacity"),
		DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionOpacity"),
		CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public double Opacity_ { get; set; }


		#region フォント
		//[CategoryAttribute("ドキュメント設定")]
		[XmlIgnore] // XmlSerializer から隠す
		[DisplayNameLocalized(typeof(Resources), "PGDisplayWindowFont"),
		DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionWindowFont"),
		CategoryLocalizedAttribute(typeof(Resources), "PGCategoryHistory")]
		public Font WindowFont_ { get; set; }

		[EditorBrowsable(EditorBrowsableState.Never)]
		[Browsable(false)]
		public string DisplayFontAsString
		{
			get { return ConvertToString(WindowFont_); }
			set { WindowFont_ = ConvertFromString<Font>(value); }
		}

		public static string ConvertToString<T>(T value)
		{
			return TypeDescriptor.GetConverter(typeof(T)).ConvertToString(value);
		}
		public static T ConvertFromString<T>(string value)
		{
			return (T)TypeDescriptor.GetConverter(typeof(T)).ConvertFromString(value);
		}
		#endregion
		#endregion

		#region 定型文定義
		/// <summary>
		/// 定型文が定義されるファイルのパス
		/// </summary>
		/// <remarks>System.Designへの参照設定を追加した。</remarks>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameTemplateFilePath"),
	   DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionTemplateFilePath"),
	   CategoryLocalizedAttribute(typeof(Resources), "PGCategoryTemplate")]
		[Editor(typeof(System.Windows.Forms.Design.FileNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
		public string templateFilePath_ { get; set; }

		///// <summary>
		///// 定型文定義ファイルを暗号化するかどうか
		///// </summary>		
		//[PropertyDisplayName("暗号化指定"), Description("定型文定義ファイルの内容を暗号化するかどうか"), Category("定型文定義")]
		//public bool bEncryptTemplateFile_ { get; set; }

		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameBackup"),
	   DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionBackup"),
	   CategoryLocalizedAttribute(typeof(Resources), "PGCategoryTemplate")]
		[Editor(typeof(System.Windows.Forms.Design.FileNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
		public bool bBackup_ { get; set; }

		#endregion


        #region スクリプト
        /// <summary>
        /// 定型文が定義されるファイルのパス
        /// </summary>
        /// <remarks>System.Designへの参照設定を追加した。</remarks>
		[DisplayNameLocalized(typeof(Resources), "PGDisplayNameScriptFileFolder"),
	   DescriptionLocalizedAttribute(typeof(Resources), "PGDescriptionScriptFileFolder"),
	   CategoryLocalizedAttribute(typeof(Resources), "PGCategoryScript")]
		[EditorAttribute(typeof(System.Windows.Forms.Design.FolderNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
		public string sriptFileFolder_ { get; set; }
        #endregion

		//public Version ApplicationVersion = Environment.Version;

		public static string APP_DATA_FOLDER_ = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData),Application.ProductName);

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public AplSetting()
		{
			Directory.CreateDirectory(APP_DATA_FOLDER_);
			Trace.WriteLine("Create " + APP_DATA_FOLDER_);

			//bEncryptTemplateFile_ = false;

			bMinimizeOnStart_ = false;
			maxHistory_ = 100;
			bInheritHistory_ = true;

			//templateFilePath_ = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), Properties.Settings.Default.DefaultTemplateFileName);
			templateFilePath_ = Path.Combine(APP_DATA_FOLDER_, Properties.Settings.Default.DefaultTemplateFileName);
			bBackup_ = true;

			hkActive_ = Keys.A | Keys.Shift | Keys.Control;
			hkDeleteHistory_ = Keys.D | Keys.Shift | Keys.Control;
			hkTemplatePopup_ = Keys.Q | Keys.Shift | Keys.Control;
			
			bAlwaysTop_ = false;

			Opacity_ = 1.0;

			sriptFileFolder_ = string.Empty;

			WindowFont_ = global::ClipClop.Properties.Settings.Default.DefaultFont;
		}

		public static AplSetting Create(string setting)
		{
			if (string.IsNullOrEmpty(setting))
				return new AplSetting();

			try
			{
				XmlSerializer serializer = new XmlSerializer(typeof(AplSetting));

				AplSetting cls = null;
				using (StringReader sr = new StringReader(setting))
				{
					cls = (AplSetting)serializer.Deserialize(sr);
				}
				return cls;
			}
			catch
			{
				return new AplSetting();
			}
		}

		public override string ToString()
		{
			//XmlSerializerオブジェクトを作成
			//書き込むオブジェクトの型を指定する
			XmlSerializer serializer = new XmlSerializer(typeof(AplSetting));

			string ret = string.Empty;
			using (StringWriter sr = new StringWriter())
			{
				serializer.Serialize(sr, this);
				ret = sr.ToString();
			}
			return ret;
		}


		public int GetHotKeyCount()
		{
			return Enum.GetNames(typeof(Hotkeys)).Length;
		}

		public System.Windows.Forms.Keys GetHotKeyAt(int index)
		{
			switch ((Hotkeys)index)
			{
				case Hotkeys.Active:
					return this.hkActive_;
				case Hotkeys.DeleteHistory:
					return this.hkDeleteHistory_;
				case Hotkeys.TemplatePopup:
					return this.hkTemplatePopup_;
			}
			return System.Windows.Forms.Keys.None;
		}
	}
}
