﻿using NUnit.Framework;
using Sasa.QualityTools.DrFx.Core.Translation;
using System;
using System.Collections.Generic;

namespace Sasa.QualityTools.DrFx.Core.Tests.Unit.Translation
{
    [TestFixture]
    public class MessageTest
    {
        [Test]
        public void TestLoadMessage()
        {
            const string contents =
                @"<?xml version=""1.0"" encoding=""utf-8""?>" +
                @"<FxCopReport Version=""1.36"">" +
                @"    <Targets>" +
                @"        <Target>" +
                @"            <Modules>" +
                @"                <Module>" +
                @"                    <Message CheckId=""CA9999"" TypeName=""Type1"">" +
                @"                        <Issue>aaabbbccc</Issue>" +
                @"                    </Message>" +
                @"                </Module>" +
                @"            </Modules>" +
                @"        </Target>" +
                @"    </Targets>" +
                @"</FxCopReport>";

            List<Message> messages = Message.Parse(contents);
            Assert.AreEqual(1, messages.Count);
            Assert.AreEqual("CA9999", messages[0].CheckId);
            Assert.AreEqual("Type1", messages[0].TypeName);
            Assert.AreEqual(1, messages[0].Issues.Count);
            Assert.AreEqual("aaabbbccc", messages[0].Issues[0]);
        }
    }
}
