﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Xml;

namespace Sasa.QualityTools.DrFx.Core.Translation
{
    /// <summary>
    /// FxCop レポートの違反メッセージを表します。
    /// </summary>
    internal class Message
    {
        /// <summary>
        /// 違反内容のリスト。
        /// </summary>
        private List<string> issues;



        /// <summary>
        /// 違反したルールのチェック ID。
        /// </summary>
        internal string CheckId { get; private set; }

        /// <summary>
        /// 違反したルールのクラス名。
        /// </summary>
        internal string TypeName { get; private set; }

        /// <summary>
        /// 違反内容のリスト。
        /// </summary>
        internal ReadOnlyCollection<string> Issues
        {
            get
            {
                return new ReadOnlyCollection<string>(this.issues);
            }
        }



        /// <summary>
        /// インスタンスを初期化します。
        /// </summary>
        private Message()
        {
            this.issues = new List<string>();
        }



        /// <summary>
        /// 指定されたレポートコンテンツを解析し、違反メッセージリストを作成します。
        /// </summary>
        /// <param name="contents">解析したいレポートコンテンツ。</param>
        /// <returns>作成した違反メッセージのリスト。</returns>
        internal static List<Message> Parse(string contents)
        {
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(contents);
            List<Message> messages = new List<Message>();
            foreach (XmlNode node in doc.SelectNodes("//Message"))
            {
                Message message = new Message();
                message.CheckId = node.Attributes["CheckId"].Value;
                message.TypeName = node.Attributes["TypeName"].Value;
                message.ParseMessage(node);
                messages.Add(message);
            }
            return messages;
        }

        /// <summary>
        /// FxCop レポートの Message ノードを解析します。
        /// </summary>
        /// <param name="messageNode">解析したい Message ノード。</param>
        private void ParseMessage(XmlNode messageNode)
        {
            foreach (XmlNode node in messageNode.SelectNodes("Issue"))
            {
                this.issues.Add(node.InnerText);
            }
        }
    }
}
