﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using Sasa.QualityTools.DrFx.Explorer.Report;
using System;
using System.Windows;
using System.Windows.Input;

namespace Sasa.QualityTools.DrFx.Explorer
{
    /// <summary>
    /// DrFx Explorer のメイン画面を表します。
    /// </summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// バージョン番号。
        /// </summary>
        private string version;



        /// <summary>
        /// バージョン番号。
        /// </summary>
        public string Version
        {
            get
            {
                if (String.IsNullOrEmpty(this.version))
                {
                    this.version = GetType().Assembly.GetName().Version.ToString();
                }
                return this.version;
            }
        }

        
        
        /// <summary>
        /// <see cref="Sasa.QualityTools.DrFx.Explorer.MainWindow"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        public MainWindow()
        {
            InitializeComponent();
        }



        /// <summary>
        /// FxCop レポート表示画面を開きます。
        /// </summary>
        /// <param name="sender">イベント送信元オブジェクト。</param>
        /// <param name="e">イベントデータ。</param>
        private void OpenReport(object sender, ExecutedRoutedEventArgs e)
        {
            string file = DialogHelper.SelectFxCopReportFile();
            if (file != null)
            {
                FxCopReportWindow window = new FxCopReportWindow();
                window.FxCopReport = FxCopReport.Load(file);
                window.Show();
            }
        }

        /// <summary>
        /// FxCop ルール画面を開きます。
        /// </summary>
        /// <param name="sender">イベント送信元オブジェクト。</param>
        /// <param name="e">イベントデータ。</param>
        private void ShowFxCopRuleWindow(object sender, RoutedEventArgs e)
        {
            FxCopRuleWindow window = new FxCopRuleWindow();
            window.Show();
        }
    }
}
