﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// ルール違反情報と、ルール違反対象や違反したルールの詳細情報をリンクさせるためのクラスです。
    /// </summary>
    public class FxCopIssueRelationship
    {
        /// <summary>
        /// ルール違反情報。
        /// </summary>
        public FxCopIssue Issue { get; set; }

        /// <summary>
        /// ルール違反対象のアセンブリの情報。もしくはルール違反対象のメンバーが属しているのアセンブリの情報。
        /// </summary>
        public AssemblyWarning Assembly { get; set; }

        /// <summary>
        /// ルール違反対象の名前空間の情報。もしくはルール違反対象のメンバーが属しているの名前空間の情報。
        /// </summary>
        public NamespaceWarning Namespace { get; set; }

        /// <summary>
        /// ルール違反対象の型の情報。もしくはルール違反対象のメンバーが属しているの型の情報。
        /// </summary>
        public TypeWarning Type { get; set; }

        /// <summary>
        /// ルール違反対象のメンバーの情報。
        /// </summary>
        public MemberWarning Member { get; set; }

        /// <summary>
        /// 違反したルール自体の情報。
        /// </summary>
        public FxCopRule Rule { get; set; }

        /// <summary>
        /// ルール違反対象。
        /// </summary>
        public WarningTarget Target { get; set; }
    }
}
