﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Console
{
    /// <summary>
    /// FxCop がコンソールに出力する警告メッセージを表します。
    /// </summary>
    public class Warning
    {
        /// <summary>
        /// ソース情報。
        /// </summary>
        public string SourceContext { get; set; }

        /// <summary>
        /// メッセージのタイプ。
        /// </summary>
        public string Level { get; set; }

        /// <summary>
        /// 違反した FxCop ルールのカテゴリー。
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// 違反した FxCop ルールのチェック ID。
        /// </summary>
        public string CheckId { get; set; }

        /// <summary>
        /// 違反メッセージ。
        /// </summary>
        public string Issue { get; set; }



        /// <summary>
        /// 指定された <paramref name="warning"/> と等値であるかどうかを比較します。
        /// </summary>
        /// <param name="warning">FxCop がコンソールに出力する警告メッセージを表す値。</param>
        /// <returns>全プロパティ値が完全に一致する場合は true。そうでない場合は false。</returns>
        public bool Equals(Warning warning)
        {
            if (warning == null)
            {
                return false;
            }
            else
            {
                return
                    SourceContext == warning.SourceContext &&
                    Level == warning.Level &&
                    Category == warning.Category &&
                    CheckId == warning.CheckId &&
                    Issue == warning.Issue;
            }
        }

        /// <summary>
        /// 指定されたオブジェクトと等値であるかどうかを比較します。
        /// </summary>
        /// <param name="obj">任意のオブジェクト。</param>
        /// <returns><paramref name="obj"/> が <see cref="Sasa.QualityTools.DrFx.Core.Warning"/> 型であり、
        /// 全プロパティ値が完全に一致する場合は true。そうでない場合は false。</returns>
        public override bool Equals(object obj)
        {
            Warning warning = obj as Warning;
            return Equals(warning);
        }

        /// <summary>
        /// このインスタンスのハッシュコードを取得します。
        /// </summary>
        /// <returns>このインスタンスのハッシュを表す値。</returns>
        public override int GetHashCode()
        {
            return SourceContext.GetHashCode() ^ Level.GetHashCode() ^ Category.GetHashCode() ^ CheckId.GetHashCode() ^ Issue.GetHashCode();
        }

        /// <summary>
        /// <paramref name="warning1"/> と <paramref name="warning2"/> が等値であるかどうかを比較します。
        /// </summary>
        /// <param name="warning1">比較対象のインスタンス。</param>
        /// <param name="warning2">比較対象のインスタンス。</param>
        /// <returns>指定された 2 つのインスタンスが等値の場合は true。そうでない場合は false。</returns>
        public static bool operator ==(Warning warning1, Warning warning2)
        {
            if (Object.Equals(warning1, null) && Object.Equals(warning2, null))
            {
                return true;
            }
            else
            {
                return (Object.Equals(warning1, null)) ? warning2.Equals(warning1) : warning1.Equals(warning2);
            }
        }

        /// <summary>
        /// <paramref name="warning1"/> と <paramref name="warning2"/> が等値でないかどうかを比較します。
        /// </summary>
        /// <param name="warning1">比較対象のインスタンス。</param>
        /// <param name="warning2">比較対象のインスタンス。</param>
        /// <returns>指定された 2 つのインスタンスが異なる値の場合は true。そうでない場合は false。</returns>
        public static bool operator !=(Warning warning1, Warning warning2)
        {
            return !(warning1 == warning2);
        }
    }
}
