﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.ObjectModel;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// FxCop ルールに違反したアセンブリの情報を表すクラスです。
    /// </summary>
    public class AssemblyWarning
    {
        /// <summary>
        /// FxCop ルールに違反した名前空間の情報のコレクション。
        /// </summary>
        private Collection<NamespaceWarning> namespaces = new Collection<NamespaceWarning>();

        /// <summary>
        /// アセンブリに対する違反メッセージのコレクション。
        /// </summary>
        private Collection<FxCopIssue> issues = new Collection<FxCopIssue>();



        /// <summary>
        /// アセンブリのフルパス。
        /// </summary>
        public string FileName { get; internal set; }

        /// <summary>
        /// アセンブリのファイル名 (ディレクトリ情報なし)。
        /// </summary>
        public string BaseName { get; internal set; }

        /// <summary>
        /// FxCop ルールに違反した名前空間の情報のコレクション。
        /// </summary>
        public Collection<NamespaceWarning> Namespaces
        {
            get
            {
                return this.namespaces;
            }
        }

        /// <summary>
        /// アセンブリに対する違反メッセージのコレクション。
        /// </summary>
        public Collection<FxCopIssue> Issues
        {
            get
            {
                return this.issues;
            }
        }
    }
}
