﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// FxCop のルールを表すクラスです。
    /// </summary>
    public class FxCopRule
    {
        /// <summary>
        /// チェック ID。
        /// </summary>
        public string CheckId { get; internal set; }

        /// <summary>
        /// ルールのカテゴリ。
        /// </summary>
        public string Category { get; internal set; }

        /// <summary>
        /// ルール名。
        /// </summary>
        public string Name { get; internal set; }

        /// <summary>
        /// ルールの詳細。
        /// </summary>
        public string Description { get; internal set; }
    }
}
