﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// ルール違反したソースコード行を表すクラスです。
    /// </summary>
    public class SourceCodeLine
    {
        /// <summary>
        /// ソースコードの行番号。
        /// </summary>
        public int LineNumber { get; internal set; }

        /// <summary>
        /// ソースコード行。
        /// </summary>
        public string Text { get; internal set; }

        /// <summary>
        /// ルール違反していると直接レポートされた行かどうか。
        /// </summary>
        public bool IsViolationLine { get; internal set; }
    }
}
