﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// FxCop ルールへの違反に関する情報を保持するクラスです。
    /// </summary>
    public class FxCopIssue
    {
        /// <summary>
        /// 違反したルールを定義しているルールクラス名。
        /// </summary>
        public string TypeName { get; internal set; }

        /// <summary>
        /// 違反したルールのカテゴリ。
        /// </summary>
        public string Category { get; internal set; }

        /// <summary>
        /// 違反したルールのチェック ID。
        /// </summary>
        public string CheckId { get; internal set; }

        /// <summary>
        /// 違反情報のステータス。
        /// </summary>
        public string Status { get; internal set; }

        /// <summary>
        /// 違反情報のレベル。
        /// </summary>
        public string Level { get; internal set; }

        /// <summary>
        /// ルール違反したソースコードのパス。
        /// </summary>
        public string FilePath { get; internal set; }

        /// <summary>
        /// ルール違反したソースコードの行番号。
        /// </summary>
        public int? Line { get; internal set; }

        /// <summary>
        /// 違反メッセージ。
        /// </summary>
        public string Content { get; internal set; }
    }
}
