﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Core.Translation
{
    /// <summary>
    /// 違反の解決方法を翻訳するための情報を表します。
    /// </summary>
    internal class Resolution
    {
        /// <summary>
        /// 翻訳結果。
        /// </summary>
        internal string Content { get; set; }

        /// <summary>
        /// 翻訳前のメッセージを特定するパターン。
        /// </summary>
        /// <remarks>
        /// 解決方法メッセージに埋め込まれている識別子を翻訳結果に埋め込むために、正規表現に
        /// よるパターンマッチングを行って、識別子を取り出す必要がある。
        /// </remarks>
        internal string Pattern { get; set; }
    }
}
