﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Usage
{
    public static class Rule1806
    {
        // このメソッドは CA1806:ObjectCreation に違反しています。
        public static void CreateInstance()
        {
            new object();
        }

        // このメソッドは CA1806:StringCreation に違反しています。
        public static void Trim(string value)
        {
            value.Trim();
        }

        // このメソッドは CA1806:HResultOrErrorCode に違反しています。
        public static string GetShortPath(string longPath)
        {
            StringBuilder shortPathBuffer = new StringBuilder(256);
            NativeMethods.GetShortPathName(longPath, shortPathBuffer, (uint)shortPathBuffer.Capacity);
            return shortPathBuffer.ToString();
        }

        // このメソッドは CA1806:TryParse に違反しています。
        public static int Convert(string value)
        {
            int result;
            Int32.TryParse(value, out result);
            return result;
        }
    }

    internal static partial class NativeMethods
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true, BestFitMapping = false, ThrowOnUnmappableChar = true)]
        public static extern uint GetShortPathName(string lpszLongPath, StringBuilder lpszShortPath, uint cchBuffer);
    }
}
