﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Runtime.Serialization;

namespace Sasa.QualityTools.DrFx.Console
{
    /// <summary>
    /// 引数をとるオプションに引数が指定されていないことを表す例外クラスです。
    /// </summary>
    [Serializable]
    internal class MissingOptionArgumentException : Exception
    {
        /// <summary>
        /// 指定されたメッセージを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外に関する情報を表すメッセージ。</param>
        internal MissingOptionArgumentException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// シリアライズされたデータを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="info">シリアライズされたデータ。</param>
        /// <param name="context">シリアライズストリーミング。</param>
        protected MissingOptionArgumentException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
