﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.Serialization;
using System.Xml;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Design
{
    // このクラスは CA1058:System.Xml.XmlDocument に違反しています。
    [ComVisible(false)]
    public class Rule1058A : XmlDocument, IEnumerable<XmlNode>
    {
        public new IEnumerator<XmlNode> GetEnumerator()
        {
            foreach (XmlNode node in ChildNodes)
            {
                yield return node;
            }
        }
    }

    // このクラスは CA1058:System.ApplicationException に違反しています。
    [Serializable]
    public class Rule1058B : ApplicationException
    {
        public Rule1058B()
        {
        }

        public Rule1058B(string message)
            : base(message)
        {
        }

        public Rule1058B(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        protected Rule1058B(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }

    // このクラスは CA1058:System.Collections.CollectionBase に違反しています。
    public class Rule1058C : CollectionBase, IList<string>
    {
        private string head;

        public bool IsReadOnly
        {
            get
            {
                return this.head == "readonly";
            }
        }

        public string this[int index]
        {
            get
            {
                return (string)List[index];
            }
            set
            {
                List[index] = value;
            }
        }

        public void CopyTo(string[] array, int arrayIndex)
        {
            this.head = array[arrayIndex];
        }

        public void Add(string item)
        {
            this.head = item;
        }

        public new void Clear()
        {
            this.head = null;
        }

        public bool Contains(string item)
        {
            return this.head == item;
        }

        public new IEnumerator<string> GetEnumerator()
        {
            yield return this.head;
        }

        public int IndexOf(string item)
        {
            return this.head.IndexOf(item, StringComparison.Ordinal);
        }

        public void Insert(int index, string item)
        {
            this.head = item.Substring(index);
        }

        public bool Remove(string item)
        {
            return this.head == item;
        }
    }

    // このクラスは CA1058:System.Collections.DictionaryBase に違反しています。
    public class Rule1058D : DictionaryBase
    {
        private string head;

        public void CopyTo(string[] array, int index)
        {
            this.head = array[index];
        }

        public override string ToString()
        {
            return this.head;
        }
    }

    // このクラスは CA1058:System.Collections.Queue に違反しています。
    public class Rule1058E : Queue, ICollection<string>
    {
        private string head;

        public bool IsReadOnly
        {
            get
            {
                return this.head == "readonly";
            }
        }

        public void CopyTo(string[] array, int arrayIndex)
        {
            this.head = array[arrayIndex];
        }

        public void Add(string item)
        {
            this.head = item;
        }

        public void Clear()
        {
            this.head = null;
        }

        public bool Contains(string item)
        {
            return this.head == item;
        }

        public bool Remove(string item)
        {
            return this.head == item;
        }

        public new IEnumerator<string> GetEnumerator()
        {
            yield return this.head;
        }

        public override string ToString()
        {
            return this.head;
        }
    }

    // このクラスは CA1058:System.Collections.ReadOnlyCollectionBase に違反しています。
    public class Rule1058F : ReadOnlyCollectionBase, ICollection<string>
    {
        private string head;

        public bool IsReadOnly
        {
            get
            {
                return this.head == "readonly";
            }
        }

        public void CopyTo(string[] array, int arrayIndex)
        {
            this.head = array[arrayIndex];
        }

        public void Add(string item)
        {
            this.head = item;
        }

        public void Clear()
        {
            this.head = null;
        }

        public bool Contains(string item)
        {
            return this.head == item;
        }

        public bool Remove(string item)
        {
            return this.head == item;
        }

        public new IEnumerator<string> GetEnumerator()
        {
            yield return this.head;
        }

        public override string ToString()
        {
            return this.head;
        }
    }

    // このクラスは CA1058:System.Collections.SortedList に違反しています。
    public class Rule1058G : SortedList
    {
        private string head;

        public void CopyTo(string[] array, int index)
        {
            this.head = array[index];
        }

        public override string ToString()
        {
            return this.head;
        }
    }

    // このクラスは CA1058:System.Collections.Stack に違反しています。
    public class Rule1058H : Stack, ICollection<string>
    {
        private string head;

        public bool IsReadOnly
        {
            get
            {
                return this.head == "readonly";
            }
        }

        public void CopyTo(string[] array, int arrayIndex)
        {
            this.head = array[arrayIndex];
        }

        public void Add(string item)
        {
            this.head = item;
        }

        public void Clear()
        {
            this.head = null;
        }

        public bool Contains(string item)
        {
            return this.head == item;
        }

        public bool Remove(string item)
        {
            return this.head == item;
        }

        public new IEnumerator<string> GetEnumerator()
        {
            yield return this.head;
        }

        public override string ToString()
        {
            return this.head;
        }
    }
}
