﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: DvgtuInstance.cs 124 2011-11-08 13:45:55Z takeshich $

using System;
using System.Windows.Forms;
using OpenMetaverse;
using dvgtuViewer.SLNetworkComm;

namespace dvgtuViewer
{
	/// <summary>
	/// Description of DvgtuInstance.
	/// </summary>
	public class DvgtuInstance
	{
		private GridClient client;
		private SLNetCom netcom;
		
		private ChatForm cForm;
		private MapForm mForm;
		private ListForm lForm;
		
		// Singleton, there can be only one instance
        private static DvgtuInstance globalInstance = null;
        public static DvgtuInstance GlobalInstance
        {
            get
            {
                if (globalInstance == null)
                {
                    globalInstance = new DvgtuInstance(new GridClient());
                }
                return globalInstance;
            }
        }
		
		public DvgtuInstance(GridClient client_)
		{
			globalInstance = this;
			
			client = client_ ;
			netcom = new SLNetCom(this);
			
		}
		
		public GridClient Client
        {
            get { return client; }
        }

        public SLNetCom Netcom
        {
            get { return netcom; }
        }
        
        public ChatForm chatForm
        {
        	get { return cForm; }
        	set { cForm = value; }
        }
        
        public MapForm mapForm
        {
        	get { return mForm; }
        	set { mForm = value; }
        }
        
        public ListForm listForm
        {
        	get { return lForm; }
        	set { lForm = value; }
        }
        
	}
}
