﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: SettingForm.cs 128 2011-11-11 13:08:43Z takeshich $

using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using OpenMetaverse;
using dvgtuViewer.SLNetworkComm;

namespace dvgtuViewer
{
	/// <summary>
	/// Description of SettingForm.
	/// </summary>
	public partial class SettingForm : Form
	{
		private DvgtuInstance dvgtuInstance;
		private GridClient Client{ get { return dvgtuInstance.Client; } }
		private SLNetCom NetCom{ get { return dvgtuInstance.Netcom; } }

		
		//Fontの情報
		//アバターの色情報
		//特別なアバター格納ArrayList
		//Dictionary<string, UUID> ExtraName2Key = new Dictionary<string, UUID>();
		private Dictionary<UUID, string> ExtraAvatarList = new Dictionary<UUID, string>();
		
		private string AvatarName;
		private ManualResetEvent NameSearchEvent = new ManualResetEvent(false);
		
		private string ChatFont;
		private int OwnAvatarColor;
		private int NormalAvatarColor;
		private int ExtraAvatarColor;
		private ArrayList ExtraAvatar = new ArrayList();
		
		private List<UUID> AvatarUUID = new List<UUID>();
		
		private const string ChatFontText = "チャットのFont";
		
		
		
		public SettingForm(DvgtuInstance dvgtuInstance)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			this.dvgtuInstance = dvgtuInstance;
			this.Load += new EventHandler(SettingForm_Load);
			
		}

		void SettingForm_Load(object sender, EventArgs e)
		{
			ArrayList AvatarList = new ArrayList();
			
			//NetCom.NetcomSync = this;
			
			//設定の書き込み
			Settings.LoadFromXmlFile();
			ChatFont = Settings.Instance.ChatFont;
			OwnAvatarColor = Settings.Instance.OwnAvatarColor;
			NormalAvatarColor = Settings.Instance.NormalAvatarColor;
			ExtraAvatarColor = Settings.Instance.ExtraAvatarColor;
			
			this.lblOwnAvatarColor.BackColor = Color.FromArgb(OwnAvatarColor);
			this.lblNormalAvatarColor.BackColor = Color.FromArgb(NormalAvatarColor);
			this.lblExtraAvatarColor.BackColor = Color.FromArgb(ExtraAvatarColor);
			
			FontConverter fx = new FontConverter();
//			Regex r = new Regex(".*[0-9.]*");
//			Match m = r.Match(ChatFont);
//			ChatFont = ChatFont.Replace(m.ToString(), "9");
			
			this.lblChatFont.Text = ChatFontText;
			//this.lblChatFont.Font = ChatFont;
			
			this.listAvatar.Enabled = false;
			this.lblExtraAvatar.Enabled = false;
			this.BtnAdd.Enabled = false;
			this.BtnDelete.Enabled = false;
			
			//font label
			this.lblChatFont.Visible = false;
			this.textBox1.Visible = false;
			this.BtnFontSelect.Visible = false;
			
			ExtraAvatar = Settings.Instance.ExtraAvatar;
			
			if (!NetCom.IsLoggedIn) return;
			
			this.listAvatar.Enabled = true;
			this.lblExtraAvatar.Enabled = true;
			this.BtnAdd.Enabled = true;
			this.BtnDelete.Enabled = true;
			
			
			
//			UUID testuuid = (UUID)"c8761415-07eb-49a3-b76d-a8f200e66535";
//			
//			Client.Avatars.RequestAvatarName(testuuid);
			
			Client.Avatars.UUIDNameReply += new EventHandler<UUIDNameReplyEventArgs>(Client_Avatars_UUIDNameReply);
			Client.Avatars.AvatarPickerReply += new EventHandler<AvatarPickerReplyEventArgs>(Client_Avatars_AvatarPickerReply);
			
			if (ExtraAvatar.Count > 0)
			{
				//avatarの名前を得る
				foreach(string avauuid in ExtraAvatar){
					AvatarUUID.Add((UUID)avauuid);
				}			
				
				Client.Avatars.RequestAvatarNames(AvatarUUID);
				
				if(!NameSearchEvent.WaitOne(15000,false)){
					//timeout時のメッセージ
					
					return;
				}
				


				foreach(KeyValuePair<UUID, string> kvpav in ExtraAvatarList)
				{
					AvatarState avatarstate = new AvatarState(kvpav.Key,kvpav.Value);
					if (!AvatarList.Contains(avatarstate)){
						AvatarList.Add(avatarstate);
					}
				}
				
				NameSearchEvent.Reset();
				
				listAvatar.DataSource = AvatarList;
				listAvatar.DisplayMember = "AvatarName";
				listAvatar.ValueMember = "AvatarID";
				
				
			}
		}

		void SettingForm_Disposed(object sender, EventArgs e)
		{
			Client.Avatars.UUIDNameReply -= new EventHandler<UUIDNameReplyEventArgs>(Client_Avatars_UUIDNameReply);
			Client.Avatars.AvatarPickerReply -= new EventHandler<AvatarPickerReplyEventArgs>(Client_Avatars_AvatarPickerReply);
		}

		void Client_Avatars_UUIDNameReply(object sender, UUIDNameReplyEventArgs e)
		{
			foreach(KeyValuePair<UUID, string> kvp in e.Names){
					if (!ExtraAvatarList.ContainsKey(kvp.Key)){
						ExtraAvatarList.Add(kvp.Key,kvp.Value);
					}
			}
			NameSearchEvent.Set();
			
		}

		void Client_Avatars_AvatarPickerReply(object sender, AvatarPickerReplyEventArgs e)
		{
			if(e.Avatars.Keys.Count == 1){
				//MessageBox.Show("このアバターは存在");
				
				foreach(KeyValuePair<UUID, string> kvpAvatar in e.Avatars){
					ExtraAvatarList.Add(kvpAvatar.Key,kvpAvatar.Value);
					//AvatarList.Add(new AvatarState(kvpAvatar.Key,kvpAvatar.Value));
				}
				NameSearchEvent.Set();
			}else
			{
				//複数ヒットした場合は、いないという判断？
				//完全一致ではないのでこのロジックはおかしい！！！
				MessageBox.Show("このアバターは非実在");
				return;
			}

			
		}

//		public void SetClient(GridClient client){
//			Client = client;
//		}
//		
//		public void SetNetCom(SLNetCom netCom){
//			NetCom = netCom;
//		}
		
		void BtnFontSelectClick(object sender, EventArgs e)
		{
			
			//FontDialogクラスのインスタンスを作成
			FontDialog fd = new FontDialog();
			FontConverter fx = new FontConverter();
			
			//初期のフォントを設定
			fd.Font = lblChatFont.Font;
			//初期の色を設定
			fd.Color = textBox1.ForeColor;
			//ユーザーが選択できるポイントサイズの最大値を設定する
			fd.MaxSize = 15;
			fd.MinSize = 10;
			//存在しないフォントやスタイルをユーザーが選択すると
			//エラーメッセージを表示する
			fd.FontMustExist = true;
			//横書きフォントだけを表示する
			fd.AllowVerticalFonts = true;
			//色を選択できるようにする
			fd.ShowColor = true;
			//取り消し線、下線、テキストの色などのオプションを指定可能にする
			//デフォルトがTrueのため必要はない
			fd.ShowEffects = true;
			//固定ピッチフォント以外も表示する
			//デフォルトがFalseのため必要はない
			fd.FixedPitchOnly = false;
			//ベクタ フォントを選択できるようにする
			//デフォルトがTrueのため必要はない
			fd.AllowVectorFonts = true;
			
			//ダイアログを表示する
			if (fd.ShowDialog() != DialogResult.Cancel)
			{
			    //TextBox1のフォントと色を変える
			    lblChatFont.Font = fd.Font;
			    //lblChatFontColor.ForeColor = fd.Color;
			    //lblChatFont.Text = Convert.ToString(fd.Font);
			    //Settings.Instance.ChatFont = f
			    
			}
			fd.Dispose();
		}
		
		void BtnColorSelectClick(object sender, EventArgs e)
		{
			// ColorDialog の新しいインスタンスを生成する (デザイナから追加している場合は必要ない)
			ColorDialog colorDialog1 = new ColorDialog();
			
			// 初期選択する色を設定する
		    colorDialog1.Color = textBox1.BackColor;
			
			// カスタム カラーを定義可能にする (初期値 true)
			//colorDialog1.AllowFullOpen = true;
			
			// カスタム カラーを表示した状態にする (初期値 false)
			colorDialog1.FullOpen = true;
			
			// 使用可能なすべての色を基本セットに表示する (初期値 false)
			colorDialog1.AnyColor = true;
			
			// 純色のみ表示する (初期値 false)
			colorDialog1.SolidColorOnly = true;
			
			// カスタム カラーを任意の色で設定する
			colorDialog1.CustomColors = new int[] {0x8040FF, 0xFF8040, 0x80FF40, 0x4080FF};
			
			// [ヘルプ] ボタンを表示する
			colorDialog1.ShowHelp = true;
			
			// ダイアログを表示し、戻り値が [OK] の場合は選択した色を textBox1 に適用する
			if (colorDialog1.ShowDialog() == DialogResult.OK) {
				textBox1.BackColor = colorDialog1.Color;
				textBox1.Text = colorDialog1.Color.ToArgb().ToString();
				//textBox1.ForeColor = Color.FromArgb(colorDialog1.Color.ToArgb());
				Settings.Instance.OwnAvatarColor = colorDialog1.Color.ToArgb();
				
			}
			
			// 不要になった時点で破棄する (正しくは オブジェクトの破棄を保証する を参照)
			colorDialog1.Dispose();
		}
		
		void BtnAddClick(object sender, EventArgs e)
		{
			try
            {
				ArrayList AvatarList = new ArrayList();
				
				AvatarNameForm avatarNameForm = new AvatarNameForm();
				avatarNameForm.ShowDialog(this);
				AvatarName = avatarNameForm.AvatarName;
				avatarNameForm.Dispose();
				
				if (string.IsNullOrEmpty(AvatarName)) return;
				
				//ExtraAvatarList.Clear();
				
				//Avatarの存在チェック
				Client.Avatars.RequestAvatarNameSearch(AvatarName,UUID.Random());
				
				NameSearchEvent.WaitOne(6000,false);
				
				//
				foreach(KeyValuePair<UUID, string> kvpav in ExtraAvatarList)
				{
					AvatarState avatarstate = new AvatarState(kvpav.Key,kvpav.Value);
					if (!AvatarList.Contains(avatarstate)){
						AvatarList.Add(avatarstate);
					}
				}
				
				NameSearchEvent.Reset();
				
				//listAvatar.Refresh();
				listAvatar.DataSource = AvatarList;
				listAvatar.DisplayMember = "AvatarName";
				listAvatar.ValueMember = "AvatarID";
				//Logger.Log("SettingForm:" + listAvatar.Items.Count.ToString(),OpenMetaverse.Helpers.LogLevel.Debug);
				
				
				
				
			}catch(Exception ex){
				Logger.Log("SettingFormBtnAddClick:" + ex.Message,OpenMetaverse.Helpers.LogLevel.Error);
			}
		}
		
		void BtnDeleteClick(object sender, EventArgs e)
		{
			if (listAvatar.Items.Count == 0) return;
			
			ArrayList AvatarList = new ArrayList();
			
			int ActiveIndex = listAvatar.SelectedIndex;
			UUID AvatarUUID = (UUID)listAvatar.SelectedValue;
			
			listAvatar.ValueMember.Remove(ActiveIndex,1);
			listAvatar.DisplayMember.Remove(ActiveIndex,1);
			listAvatar.DataSource = null;

			ExtraAvatarList.Remove(AvatarUUID);
			
			foreach(KeyValuePair<UUID, string> kvpav in ExtraAvatarList)
			{
				AvatarState avatarstate = new AvatarState(kvpav.Key,kvpav.Value);
				if (!AvatarList.Contains(avatarstate)){
					AvatarList.Add(avatarstate);
				}
			}
			
			listAvatar.DataSource = AvatarList;
			listAvatar.DisplayMember = "AvatarName";
			listAvatar.ValueMember = "AvatarID";

		}
		
		
		void BtnApplyClick(object sender, EventArgs e)
		{
			if (NetCom.IsLoggedIn){
				if (ExtraAvatarList.Count == 0){
					Settings.Instance.ExtraAvatar.Clear();
				}else{
					foreach(KeyValuePair<UUID, string> kvpav in ExtraAvatarList)
					{
						if (!Settings.Instance.ExtraAvatar.Contains(kvpav.Key.ToString())){
							Settings.Instance.ExtraAvatar.Add(kvpav.Key.ToString());
						}		
					}	
				}
			}

			Settings.SaveToXmlFile();
			this.Close();
		}
		
		void LblOwnAvatarColorClick(object sender, EventArgs e)
		{
			lblOwnAvatarColor.BackColor = SetColorValue(lblOwnAvatarColor);
			Settings.Instance.OwnAvatarColor = lblOwnAvatarColor.BackColor.ToArgb();
		}
		
		Color SetColorValue(System.Windows.Forms.Label lbl){
			
			Color TmpColor = lbl.BackColor;
			
			// ColorDialog の新しいインスタンスを生成する (デザイナから追加している場合は必要ない)
			ColorDialog colorDialog1 = new ColorDialog();
			
			// 初期選択する色を設定する
		    colorDialog1.Color = Color.Pink;
			
			// カスタム カラーを定義可能にする (初期値 true)
			//colorDialog1.AllowFullOpen = true;
			
			// カスタム カラーを表示した状態にする (初期値 false)
			colorDialog1.FullOpen = true;
			
			// 使用可能なすべての色を基本セットに表示する (初期値 false)
			colorDialog1.AnyColor = true;
			
			// 純色のみ表示する (初期値 false)
			colorDialog1.SolidColorOnly = true;
			
			// カスタム カラーを任意の色で設定する
			colorDialog1.CustomColors = new int[] {0x8040FF, 0xFF8040, 0x80FF40, 0x4080FF};
			
			// [ヘルプ] ボタンを表示する
			colorDialog1.ShowHelp = true;
			
			// ダイアログを表示し、戻り値が [OK] の場合は選択した色を textBox1 に適用する
			if (colorDialog1.ShowDialog() == DialogResult.OK) {
				TmpColor = colorDialog1.Color;
			}
			
			// 不要になった時点で破棄する (正しくは オブジェクトの破棄を保証する を参照)
			colorDialog1.Dispose();
			return TmpColor;
		}
		
		void LblNormalAvatarColorClick(object sender, EventArgs e)
		{
			lblNormalAvatarColor.BackColor = SetColorValue(lblNormalAvatarColor);
			Settings.Instance.NormalAvatarColor = lblNormalAvatarColor.BackColor.ToArgb();
		}
		
		void LblExtraAvatarColorClick(object sender, EventArgs e)
		{
			lblExtraAvatarColor.BackColor = SetColorValue(lblExtraAvatarColor);
			Settings.Instance.ExtraAvatarColor = lblExtraAvatarColor.BackColor.ToArgb();
		}
		
		void BtnCancelClick(object sender, EventArgs e)
		{
			this.Close();
		}
		
	}
}
