/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore;

// mutable.

public final class DviRegister
implements Cloneable, java.io.Serializable
{
  private static final long serialVersionUID = 7923032642831406085L;
  private int h, v, w, x, y, z;

  public DviRegister() {
  }

  public DviRegister(DviRegister reg) {
    this.h = reg.h;
    this.v = reg.v;
    this.w = reg.w;
    this.x = reg.x;
    this.y = reg.y;
    this.z = reg.z;
  }

  public void copy(DviRegister reg) {
    this.h = reg.h;
    this.v = reg.v;
    this.w = reg.w;
    this.x = reg.x;
    this.y = reg.y;
    this.z = reg.z;
  }

  public int getH() { return h; }
  public int getV() { return v; }
  public int getW() { return w; }
  public int getX() { return x; }
  public int getY() { return y; }
  public int getZ() { return z; }

  public void setH(int h) { this.h = h; }
  public void setV(int v) { this.v = v; }
  public void setW(int w) { this.w = w; }
  public void setX(int x) { this.x = x; }
  public void setY(int y) { this.y = y; }
  public void setZ(int z) { this.z = z; }

  public void addH(int d) { h += d; }
  public void addV(int d) { v += d; }
  public void addW(int d) { w += d; }
  public void addX(int d) { x += d; }
  public void addY(int d) { y += d; }
  public void addZ(int d) { z += d; }

  public void reset() {
    h = v = w = x = y = z = 0;
  }

  public String toString() {
    return getClass().getName() + "[h=" + h +
                      " v=" + v +
                      " w=" + w +
                      " x=" + x +
                      " y=" + y +
                      " z=" + z + "]";
  }
  public Object clone() {
    try {
      return super.clone();
    } catch (CloneNotSupportedException ex) {
      throw new InternalError();
    }
  }
  public boolean equals(Object obj) {
    if (obj instanceof DviRegister) {
      DviRegister a = (DviRegister) obj;
      return a.h == h && a.v == v && a.w == w &&
             a.x == x && a.y == y && a.z == z;
    }
    return false;
  }
  public int hashCode() {
    return h + 33*(v + 33*(w + 33*(x + 33*(y + 33*z))));
  }
}
