package jp.sourceforge.dvibrowser.dvicore.image.pnm;
/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviRect;
import jp.sourceforge.dvibrowser.dvicore.DviSize;
import jp.sourceforge.dvibrowser.dvicore.image.split.SplitImageWriter;

public class PnmSplitter
extends AbstractPnmSplitter
{
//  private static final Logger LOGGER = Logger.getLogger(PnmSplitter.class
//      .getName());
  protected AbstractPnmSplitter delegate;
  
  public PnmSplitter(DviSize unitSize, SplitImageWriter imageWriter)
  {
    super(unitSize, imageWriter);
    delegate = null;
  }
  
  @Override
  public void beginSplitInternal(PnmHeader header, InputStream is) throws DviException
  {
    super.beginSplitInternal(header, is);
    final int type = header.getType();
    switch (type) {
    case PnmHeader.PNM_TYPE_BITMAP_ASCII:
      delegate = new PbmSplitter(getUnitSize(), imageWriter);
      is = new PnmBitAsciiFilter(is);
      break;
    case PnmHeader.PNM_TYPE_GRAYMAP_ASCII:
      delegate = new PgmSplitter(getUnitSize(), imageWriter);
      is = new PnmByteAsciiFilter(is);
      break;
    case PnmHeader.PNM_TYPE_PIXMAP_ASCII:
      delegate = new PpmSplitter(getUnitSize(), imageWriter);
      is = new PnmByteAsciiFilter(is);
      break;
    case PnmHeader.PNM_TYPE_BITMAP_BINARY:  delegate = new PbmSplitter(getUnitSize(), imageWriter); break;
    case PnmHeader.PNM_TYPE_GRAYMAP_BINARY: delegate = new PgmSplitter(getUnitSize(), imageWriter); break;
    case PnmHeader.PNM_TYPE_PIXMAP_BINARY:  delegate = new PpmSplitter(getUnitSize(), imageWriter); break;
    }
    if (delegate != null) {
      delegate.beginSplitInternal(header, is);
    } else {
      throw new IllegalStateException("Unsupported PNM image type: " + type);
    }
  }
  
  @Override
  public void readFully(byte [] buf) throws IOException
  {
    delegate.readFully(buf);
  }
  
  @Override
  public void endSplitInternal() throws DviException
  {
    if (delegate != null) {
      delegate.endSplitInternal();
      delegate = null;
    }
  }
  
  @Override
  protected byte [] createLineBuffer()
  {
    return delegate.createLineBuffer();
  }
  
  @Override
  protected BufferedImage createBufferedImage(DviRect box)
  {
    return delegate.createBufferedImage(box);
  }
  
  @Override
  protected int copyLineToDataBuffer(byte [] buf, int x, DviRect box, int i, DataBufferByte data)
  {
    return delegate.copyLineToDataBuffer(buf, x, box, i, data);
  }
}
