/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package jp.sourceforge.dvibrowser.dvicore.image.split;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviRect;
import jp.sourceforge.dvibrowser.dvicore.DviRectSplitter;
import jp.sourceforge.dvibrowser.dvicore.DviResolution;

public abstract class AbstractSplitPiece
implements SplitPiece
{
//  private static final Logger LOGGER = Logger
//      .getLogger(AbstractSplitPiece.class.getName());
  private final DviResolution res;
  private final DviRectSplitter rectSplitter;
  private final int row;
  private final int col;
  private final SplitImage splitImage;

  public AbstractSplitPiece(SplitImage splitImage, DviResolution res, DviRectSplitter rectSplitter, int row, int col)
  {
    this.splitImage = splitImage;
    this.res = res;
    this.rectSplitter = rectSplitter;
    this.row = row;
    this.col = col;
  }
  
  public DviResolution getResolution()
  {
    return res;
  }

  public DviRectSplitter getRectSplitter() {
    return rectSplitter;
  }

  public int getRow() {
    return row;
  }

  public int getColumn() {
    return col;
  }

  public SplitImage getSplitImage() {
    return splitImage;
  }
  
  public DviRect getRect() throws DviException {
    return getRectSplitter().getRectAt(row, col);
  }
}
