/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.image.split;
public class ImageFileConfig {
  public static final ImageFileConfig PNG = new ImageFileConfig("png", ".png");
  public static final ImageFileConfig GIF = new ImageFileConfig("gif", ".gif");
  public static final ImageFileConfig JPEG = new ImageFileConfig("jpeg", ".jpg");
  
  private final String imageType;
  private final String imageExt;

  public ImageFileConfig(String imageType, String imageExt)
  {
    if (imageType == null)
      throw new IllegalArgumentException("imageType can't be null");
    if (imageExt == null)
      throw new IllegalArgumentException("imageExt can't be null");
    
    this.imageType = imageType;
    this.imageExt = imageExt;
  }

  public String getImageType() {
    return imageType;
  }

  public String getImageExtension() {
    return imageExt;
  }
  
  public boolean equals(Object o)
  {
    if (!(o instanceof ImageFileConfig))
      return false;
    
    ImageFileConfig oo = (ImageFileConfig) o;
    return oo.imageType.equals(imageType) && oo.imageExt.equals(imageExt);
  }
  
  public int hashCode()
  {
    return imageType.hashCode() + 33*imageExt.hashCode();
  }
}
