/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.util.progress;

import javax.swing.event.EventListenerList;

import jp.sourceforge.dvibrowser.dvicore.DviObject;
import jp.sourceforge.dvibrowser.dvicore.api.DviContextSupport;


public abstract class AbstractProgressModel extends DviObject {

  protected EventListenerList listenerList = new EventListenerList();

  public AbstractProgressModel(DviContextSupport dcs) {
    super(dcs);
  }

  public void addProgressListener(ProgressListener l)
  {
      listenerList.add(ProgressListener.class, l);
  }

  public void removeProgressListener(ProgressListener l)
  {
      listenerList.remove(ProgressListener.class, l);
  }

  protected void fireProgressOpenEvent(ManagedProgressItem item)
  {
    ProgressEvent event = null;
    
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i] == ProgressListener.class) {
        if (event == null)
          event = new ProgressEvent(this, item);
        ((ProgressListener)listeners[i+1]).progressOpen(event);
      }
    }
  }

  protected void fireProgressCloseEvent(ManagedProgressItem item)
  {
    ProgressEvent event = null;
    
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i] == ProgressListener.class) {
        if (event == null)
          event = new ProgressEvent(this, item);
        ((ProgressListener)listeners[i+1]).progressClose(event);
      }
    }
  }

  protected void fireProgressUpdateEvent(ManagedProgressItem item)
  {
    ProgressEvent event = null;
    
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i] == ProgressListener.class) {
        if (event == null)
          event = new ProgressEvent(this, item);
        ((ProgressListener)listeners[i+1]).progressUpdate(event);
      }
    }
  }
  
  public abstract ProgressItem getMostRecentItem();

}