var dvi2epub = {};

dvi2epub.stageId = 'dvi2epubStage';
dvi2epub.state = {};

dvi2epub.loadTable = function (json) {
  message("dvi2epub: loadTable().");
  var as = new Array();
  for (var i in json) {
    var rec = json[i];
    as.push(rec);
  }
  dvi2epub.table = as;
  dvi2epub.total_pages = as.length;
  message("dvi2epub: " + dvi2epub.total_pages + " page(s).");
};

dvi2epub.openPage = function (n) {
  message("dvi2epub: openPage: n=" + n);
  //var stage = document.getElementById(dvi2epub.stageId);
  var stage = dvi2epubStage;
  if (stage == null) {
    throw new Error("Failed to find stage: " + dvi2epub.stageId);
  }
  var url = this.table[n].url;
  message("Open: " + url);
  stage.location.href = url;
  this.state.currentPage = n;
};

dvi2epub.isValidPage = function (n) {
  return (0 <= n && n < this.total_pages);
};

dvi2epub.hasNextPage = function () {
  return this.isValidPage(this.state.currentPage + 1);
};

dvi2epub.hasPrevPage = function () {
  return this.isValidPage(this.state.currentPage - 1);
};

dvi2epub.nextPage = function () {
  message("dvi2epub: nextPage");
  if (this.hasNextPage) {
    this.openPage(this.state.currentPage + 1);
  }
};

dvi2epub.prevPage = function () {
  message("dvi2epub: prevPage");
  if (this.hasPrevPage) {
    this.openPage(this.state.currentPage - 1);
  }
};

dvi2epub.getCurrentPage = function () {
  return this.state.currentPage;
};

dvi2epub.getPage = function (n) {
  if (this.isValidPage(n)) {
    return this.table[n];
  }
  return undefined;
};

dvi2epub.init = function () {
  try {
    loadPage();
  } catch (e) {
    message("Caught exception: " + e);
  }
  message("dvi2epub: Initialized");
  this.state.initialized = true;
};

dvi2epub.done = function () {
  try {
    unloadPage();
  } catch (e) {
    message("Caught exception: " + e);
  }
  message("dvi2epub: Finalized.");
};
