/*
 * Copyright (c) 2012, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvi2epub.cmd;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


public class CommandUtils {
	private CommandUtils() {}

	public static int executeCommand(Class<?> cls, String[] args)
			throws CommandException {
		try {
			if (Command.class.isAssignableFrom(cls)) {
				Command cmd = (Command) cls.newInstance();
				int ret = cmd.execute(args);
				if (cmd.wantExit()) {
					System.exit(ret);
				}
				return ret;
			} else {
				run(cls.getName(), args);
				return Command.EXIT_SUCCESS;
			}
		} catch (Exception e) {
			throw new CommandException(e);
		}
	}
	
	public static void run(String classname, String[] args) throws Exception {
		Class<?> cls = Class.forName(classname);
		cls.getMethod("main", new Class[] { String[].class })
		  .invoke(null, new Object[] { args });
	}
	
	public static boolean parseBoolean(String arg, boolean value) {
		if (arg == null) return value;
		arg = arg.toLowerCase().trim();
		if (arg.equals("true") || arg.equals("yes")) {
			return true;
		}
		return false;
	}
	
	public static <T> T unescapeNull(T value)
	{
		if (value instanceof String && Command.NULL.equals(value))
			return null;
		return value;
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T readValue(Class<T> cls, Object object, String methodName) {
		try {
			Method m = object.getClass().getDeclaredMethod(methodName,
					new Class<?>[] {});
			return CommandUtils.unescapeNull((T) m.invoke(object));
		} catch (NoSuchMethodException ex) {
			// Ignored.
		} catch (IllegalArgumentException e) {
			// Ignored.
		} catch (IllegalAccessException e) {
			// Ignored.
		} catch (InvocationTargetException e) {
			// Ignored.
		}
		return null;
	}
	
}
