/*
 * Copyright (c) 2012, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvi2epub.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParserState {
	private final String[] args;
	private List<String> list = new ArrayList<String>();
	private Throwable throwable;
	private boolean stop = false;
	private String optionName;
	private String optionParameter;

	public ParserState(String [] args) {
		this.args = args;
		this.list.addAll(Arrays.asList(args));
	}

	public String[] getOriginalArgs() {
		return args;
	}

	public List<String> getList() {
		return list;
	}

	public String shift() {
		String ret = null;
		if (list.size() > 0) {
			ret = list.remove(0);
		}
		return ret;
	}
	
	public void unshift(String value) {
		list.add(0, value);
	}

	public boolean wantStop() {
		return stop;
	}

	public void wantStop(boolean stop) {
		this.stop = stop;
	}
	
	public void setError(Throwable ex) {
		this.throwable = ex;
	}
	
	public void stopWithError(Throwable ex) {
		setError(ex);
		wantStop(true);
	}

	public Throwable getThrowable() {
		return this.throwable;
	}
	
	public boolean hasError() {
		return getThrowable() != null;
	}

	public String getOptionParameter() {
		return optionParameter;
	}

	public void setOptionParameter(String optionParameter) {
		this.optionParameter = optionParameter;
	}

	public String getOptionName() {
		return optionName;
	}

	public void setOptionName(String optionName) {
		this.optionName = optionName;
	}
}
