/*
 * Copyright (c) 2012, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvi2epub.opt;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import jp.sourceforge.dvibrowser.dvi2epub.cmd.CommandUtils;
import jp.sourceforge.dvibrowser.dvi2epub.cmd.Option;
import jp.sourceforge.dvibrowser.dvi2epub.cmd.OptionMapper;
import jp.sourceforge.dvibrowser.dvi2epub.cmd.ParserState;

public class DefaultOptionMapper
implements OptionMapper
{
	public DefaultOptionMapper() {
	}
	
	public Object[] map(ByteValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String a = (param == null) ? state.shift() : param;
		byte value = (a == null) ? p.value() : Byte.parseByte(a);
		return new Object[] { value };
	}
	
	public Object[] map(ShortValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String a = (param == null) ? state.shift() : param;
		short value = (a == null) ? p.value() : Short.parseShort(a);
		return new Object[] { value };
	}
	
	public Object[] map(IntValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String a = (param == null) ? state.shift() : param;
		int value = (a == null) ? p.value() : Integer.parseInt(a);
		return new Object[] { value };
	}
	
	public Object[] map(DoubleValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String a = (param == null) ? state.shift() : param;
		double value = (a == null) ? p.value() : Double.parseDouble(a);
		return new Object[] { value };
	}
	
	public Object[] map(FloatValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String a = (param == null) ? state.shift() : param;
	    float value = (a == null) ? p.value() : Float.parseFloat(a);
		return new Object[] { value };
	}



	public Object[] map(StringValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		String value = CommandUtils.unescapeNull((CommandUtils
				.unescapeNull(param) == null) ? p.value() : param);
		return new Object[] { value };
	}

	public Object[] map(BooleanValueOption p, ParserState state) {
		String param = state.getOptionParameter();
		boolean value = CommandUtils.parseBoolean(param, p.value());
		return new Object[] { value };
	}
	
	public Option getOption(Method method) {
		Annotation[] annotations = method.getDeclaredAnnotations();
		for (Annotation a : annotations) {
			String shortName = CommandUtils.readValue(String.class, a, "shortName");
			String longName = CommandUtils.readValue(String.class, a, "longName");
			String description = CommandUtils.readValue(String.class, a, "description");

			if (longName != null || shortName != null) {
				Option option = new Option(a, method, shortName, longName, description);
				return option;
			}
		}
		return null;
	}
}
