/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore;

import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class DviFontTable
extends ConcurrentHashMap<Integer, DviFontSpec>
{
  private static final long serialVersionUID = -5082474565659155765L;

  public DviFontTable() {
    super();
  }

  public DviFontTable transformForVirtualFont(DviFontSpec parent, int vfDesignSize)
  {
    DviFontTable ft = new DviFontTable();

    for (int fn : keySet()) {
      DviFontSpec fs = get(fn);
      ft.put(
        fn,
        DviFontSpec.getInstance(
          fs.checkSum(),
          (int)(
            parent.spaceSize() * (double) fs.spaceSize()
            / (double)(1 << 20)
          ),
          (int)(
            parent.designSize() * (double) fs.designSize()
            / (double) vfDesignSize
          ),
          fs.fontName()
        )
      );
    }

    return ft;
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    for (int fn : new TreeSet<Integer>(keySet())) {
      DviFontSpec fs = (DviFontSpec) get(fn);
      sb.append("fn[" + fn + "]=" + ((fs != null) ? fs.toString() : "null"));
    }
    return sb.toString();
  }
}
