/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.cmd;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviUnit;

// immutable.

public class DviPreamble
implements java.io.Serializable
{
  private static final long serialVersionUID = -455212635042527368L;
  private final int idByte;
  private final DviUnit dviUnit;
  private final byte [] comment;

  public DviPreamble(int idByte, DviUnit dviUnit, byte [] comment)
    throws DviException
  {
    this.idByte  = idByte;
    this.dviUnit = dviUnit;
    this.comment = comment.clone();
  }

  public int idByte() { return idByte; }
  public DviUnit dviUnit() { return dviUnit; }
  public byte [] comment() { return comment.clone(); }

  public String toString() {
    return getClass().getName() + "[idByte=" + idByte + ",dviUnit=" + dviUnit +
             ",comment=\"" + new String(comment) + "\"]";
  }

  public boolean equals(Object o) {
    if (o instanceof DviPreamble) {
      DviPreamble p = (DviPreamble) o;
      return p.idByte == idByte
          && p.dviUnit.equals(dviUnit)
          && new String(p.comment).equals(new String(comment))
          ;
    }
    return false;
  }

  public int hashCode() {
    return idByte + 33*(dviUnit.hashCode()
         + 33 * new String(comment).hashCode())
         ;
  }
}
