/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.render;
import java.util.logging.Logger;

import jp.sourceforge.dvibrowser.dvicore.DviObject;
import jp.sourceforge.dvibrowser.dvicore.DviRect;
import jp.sourceforge.dvibrowser.dvicore.DviResolution;
import jp.sourceforge.dvibrowser.dvicore.api.DviContextSupport;
import jp.sourceforge.dvibrowser.dvicore.api.DviPage;
import jp.sourceforge.dvibrowser.dvicore.api.Geometer;
import jp.sourceforge.dvibrowser.dvicore.util.concurrent.Computation;


public class DviBoundingBoxPreparator
extends DviObject
implements Computation<String, DviRect> {
  private static final Logger LOGGER = Logger
      .getLogger(DviBoundingBoxPreparator.class.getName());
  private final DviPage page;
  private final DviResolution res;

  public DviBoundingBoxPreparator(DviContextSupport dcs, DviPage page, DviResolution res) {
    super(dcs);
    this.page = page;
    this.res = res;
  }
  
  public DviRect call() throws Exception
  {
    BoundingBoxComputer bbc = new BoundingBoxComputer(res);
    DefaultDevicePainter dp = new DefaultDevicePainter(this);
    dp.setEnableCharBoundingBox(true);
    dp.setEnableCharRendering(false);
    dp.setOutput(bbc);
    Geometer geometer = new BasicGeometer(this);
    geometer.setPainter(dp);
    getDviContext().execute(page, geometer);
    DviRect bbox = bbc.getBoundingBox();
    LOGGER.finer("bounding box=" + bbox + " resolution=" + res + " page=" + page);
    return bbox;
  }
  
  public String getCacheKey() {
    String key = page.getCacheKey() + "-" + res.dpi();
    return key;
  }
}
