/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.util.concurrent;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class CacheEntry<K, V> {
//  private static final Logger LOGGER = Logger.getLogger(CachedItem.class
//      .getName());
  private final Computer<K, V> cachedComputer;
  private final Computation<K, V> computable;
  private final Future<V> future;
  private final long serialNumber;
  private static final AtomicLong serializer = new AtomicLong();
  
  public CacheEntry(Computer<K, V> cachedComputer, Computation<K, V> computable, Future<V> future)
  {
    this.cachedComputer = cachedComputer;
    this.computable = computable;
    this.future = future;
    this.serialNumber = serializer.incrementAndGet();
  }

  public Computer<K, V> getCachedComputer()
  {
    return cachedComputer;
  }

  public Computation<K, V> getComputable()
  {
    return computable;
  }

  public Future<V> getFuture()
  {
    return future;
  }

  public long getSerialNumber()
  {
    return serialNumber;
  }
  
  public String toString()
  {
    return getClass().getName()
      + "["
      + "serialNumber=" + serialNumber
      + ",key=" + computable.getCacheKey()
      + ",future=" + future
      + "]";
  }
}
