/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore;

public final class DviSize
implements java.io.Serializable
{
  private static final long serialVersionUID = 2774228595468843394L;
  public final int width;
  public final int height;

  public DviSize(int width, int height)
  {
    this.width = width;
    this.height = height;
  }

  public int width() { return width; }
  public int height() { return height; }

  public String toString() {
    return getClass().getName() + "[width=" + width + ",height=" + height + "]";
  }

  public int hashCode() {
    return width + 33*height;
  }

  public boolean equals(Object obj) {
    if (obj instanceof DviSize) {
      DviSize a = (DviSize) obj;
      return a.width == width && a.height == height;
    }
    return false;
  }

  public DviSize magnify(double scale) {
    return new DviSize((int)(width * scale + 0.5), (int)(height * scale + 0.5));
  }

  public DviSize magnify(double hScale, double vScale) {
    return new DviSize((int) (width * hScale + 0.5), (int) (height * vScale + 0.5));
  }
}
