/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.cmd;

public class DviCommand
{
  private DviCommand() {} // To disable instantiation.
  
  public static final int DVI_SET1 = 128;
  public static final int DVI_SET2 = 129;
  public static final int DVI_SET3 = 130;
  public static final int DVI_SET4 = 131;

  public static final int DVI_SET_RULE = 132;

  public static final int DVI_PUT1 = 133;
  public static final int DVI_PUT2 = 134;
  public static final int DVI_PUT3 = 135;
  public static final int DVI_PUT4 = 136;

  public static final int DVI_PUT_RULE = 137;

  public static final int DVI_NOP = 138;
  public static final int DVI_BOP = 139;
  public static final int DVI_EOP = 140;
  public static final int DVI_PUSH = 141;
  public static final int DVI_POP = 142;

  public static final int DVI_RIGHT1 = 143;
  public static final int DVI_RIGHT2 = 144;
  public static final int DVI_RIGHT3 = 145;
  public static final int DVI_RIGHT4 = 146;

  public static final int DVI_DOWN1 = 157;
  public static final int DVI_DOWN2 = 158;
  public static final int DVI_DOWN3 = 159;
  public static final int DVI_DOWN4 = 160;


  public static final int DVI_W0 = 147;
  public static final int DVI_W1 = 148;
  public static final int DVI_W2 = 149;
  public static final int DVI_W3 = 150;
  public static final int DVI_W4 = 151;

  public static final int DVI_X0 = 152;
  public static final int DVI_X1 = 153;
  public static final int DVI_X2 = 154;
  public static final int DVI_X3 = 155;
  public static final int DVI_X4 = 156;

  public static final int DVI_Y0 = 161;
  public static final int DVI_Y1 = 162;
  public static final int DVI_Y2 = 163;
  public static final int DVI_Y3 = 164;
  public static final int DVI_Y4 = 165;

  public static final int DVI_Z0 = 166;
  public static final int DVI_Z1 = 167;
  public static final int DVI_Z2 = 168;
  public static final int DVI_Z3 = 169;
  public static final int DVI_Z4 = 170;

  public static final int DVI_FONT1 = 235;
  public static final int DVI_FONT2 = 236;
  public static final int DVI_FONT3 = 237;
  public static final int DVI_FONT4 = 238;

  public static final int DVI_XXX1 = 239;
  public static final int DVI_XXX2 = 240;
  public static final int DVI_XXX3 = 241;
  public static final int DVI_XXX4 = 242;
                         
  public static final int DVI_FNT_DEF1 = 243;
  public static final int DVI_FNT_DEF2 = 244;
  public static final int DVI_FNT_DEF3 = 245;
  public static final int DVI_FNT_DEF4 = 246;

  public static final int DVI_POST = 248;
  public static final int DVI_POST_POST = 249;
  public static final int DVI_PRE = 247;

  public static final int DVI_UNDEF1 = 250;
  public static final int DVI_UNDEF2 = 251;
  public static final int DVI_UNDEF3 = 252;
  public static final int DVI_UNDEF4 = 253;
  public static final int DVI_UNDEF5 = 254;
  public static final int DVI_UNDEF6 = 255;
  public static final int DVI_TDIR = 255; /* For Japanese pTeX */

  private static final String [] commandNames = {
  "SETC_000","SETC_001","SETC_002","SETC_003","SETC_004",
  "SETC_005","SETC_006","SETC_007","SETC_008","SETC_009",
  "SETC_010","SETC_011","SETC_012","SETC_013","SETC_014",
  "SETC_015","SETC_016","SETC_017","SETC_018","SETC_019",
  "SETC_020","SETC_021","SETC_022","SETC_023","SETC_024",
  "SETC_025","SETC_026","SETC_027","SETC_028","SETC_029",
  "SETC_030","SETC_031","SETC_032","SETC_033","SETC_034",
  "SETC_035","SETC_036","SETC_037","SETC_038","SETC_039",
  "SETC_040","SETC_041","SETC_042","SETC_043","SETC_044",
  "SETC_045","SETC_046","SETC_047","SETC_048","SETC_049",
  "SETC_050","SETC_051","SETC_052","SETC_053","SETC_054",
  "SETC_055","SETC_056","SETC_057","SETC_058","SETC_059",
  "SETC_060","SETC_061","SETC_062","SETC_063","SETC_064",
  "SETC_065","SETC_066","SETC_067","SETC_068","SETC_069",
  "SETC_070","SETC_071","SETC_072","SETC_073","SETC_074",
  "SETC_075","SETC_076","SETC_077","SETC_078","SETC_079",
  "SETC_080","SETC_081","SETC_082","SETC_083","SETC_084",
  "SETC_085","SETC_086","SETC_087","SETC_088","SETC_089",
  "SETC_090","SETC_091","SETC_092","SETC_093","SETC_094",
  "SETC_095","SETC_096","SETC_097","SETC_098","SETC_099",
  "SETC_100","SETC_101","SETC_102","SETC_103","SETC_104",
  "SETC_105","SETC_106","SETC_107","SETC_108","SETC_109",
  "SETC_110","SETC_111","SETC_112","SETC_113","SETC_114",
  "SETC_115","SETC_116","SETC_117","SETC_118","SETC_119",
  "SETC_120","SETC_121","SETC_122","SETC_123","SETC_124",
  "SETC_125","SETC_126","SETC_127",
  "SET1","SET2","SET3","SET4","SET_RULE",
  "PUT1","PUT2","PUT3","PUT4","PUT_RULE",
  "NOP","BOP","EOP","PUSH","POP",
  "RIGHT1","RIGHT2","RIGHT3","RIGHT4",
  "W0","W1","W2","W3","W4",
  "X0","X1","X2","X3","X4",
  "DOWN1","DOWN2","DOWN3","DOWN4",
  "Y0","Y1","Y2","Y3","Y4",
  "Z0","Z1","Z2","Z3","Z4",
  "FONT_00","FONT_01","FONT_02","FONT_03","FONT_04",
  "FONT_05","FONT_06","FONT_07","FONT_08","FONT_09",
  "FONT_10","FONT_11","FONT_12","FONT_13","FONT_14",
  "FONT_15","FONT_16","FONT_17","FONT_18","FONT_19",
  "FONT_20","FONT_21","FONT_22","FONT_23","FONT_24",
  "FONT_25","FONT_26","FONT_27","FONT_28","FONT_29",
  "FONT_30","FONT_31","FONT_32","FONT_33","FONT_34",
  "FONT_35","FONT_36","FONT_37","FONT_38","FONT_39",
  "FONT_40","FONT_41","FONT_42","FONT_43","FONT_44",
  "FONT_45","FONT_46","FONT_47","FONT_48","FONT_49",
  "FONT_50","FONT_51","FONT_52","FONT_53","FONT_54",
  "FONT_55","FONT_56","FONT_57","FONT_58","FONT_59",
  "FONT_60","FONT_61","FONT_62","FONT_63",
  "FNT1","FNT2","FNT3","FNT4",
  "XXX1","XXX2","XXX3","XXX4",
  "FNT_DEF1","FNT_DEF2","FNT_DEF3","FNT_DEF4",
  "PRE","POST","POST_POST",
  "UNDEF_250","UNDEF_251","UNDEF_252","UNDEF_253","UNDEF_254","UNDEF_255"
  };

  public static String getName(int c) {
    if (c < 0 || c > 255)
      throw new IllegalArgumentException
        ("no dvi command with code " + c + ".");
    return commandNames[c];
  }
}
