/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TexLogViewer extends JPanel {
  private static final long serialVersionUID = 7630772409309800485L;
  private final JScrollPane scroll;
  private final JTextArea textArea;
  private boolean hasError = false;
  
  private File dviFile;
  public TexLogViewer(int rows, int cols) {
    setDviFile(null);
    textArea = new JTextArea(rows, cols);
    textArea.setOpaque(true);
    textArea.setEditable(false);
    scroll = new JScrollPane(textArea);
    setLayout(new BorderLayout());
    add(scroll, BorderLayout.CENTER);
  }
  
  public File getDviFile() { return dviFile; }
  public void setDviFile(File dviFile) {
    this.dviFile = dviFile;
    setupView();
  }
  
  private File getLogFile() {
    String filename = dviFile.getPath();
    String filenameBase = filename.replaceFirst("\\.[_a-zA-Z0-9]*$", "");
    File logFile = new File(filenameBase + ".log");
    return logFile;
  }
  
  private void setupView() {
    hasError = false;
    if (dviFile == null) return;

    File logFile = getLogFile();
    boolean success = true;
    if (logFile.exists()) {
      StringBuilder sb = new StringBuilder();
      String extraInfo = "";
      try {
        Scanner s = new Scanner(logFile);
        while (s.hasNextLine()) {
          String line = s.nextLine();
          sb.append(line);
          if (0 == line.indexOf("! Emergency stop.")) {
            success = false;
            Pattern pat = Pattern.compile("^l.([0-9]*) (.*)$");
            while (s.hasNextLine()) {
              line = s.nextLine();
              sb.append(line);
              Matcher mat = pat.matcher(line);
              if (mat.matches()) {
                extraInfo = line;
                break;
              }
            }
          }
          sb.append("\n");
        }
        s.close();
        sb.append("---[FOUND ERRORS]---\n");
        sb.append(extraInfo + "\n");
        textArea.setText(sb.toString());
      } catch (FileNotFoundException e) {
        e.printStackTrace();
      }
    }
    if (success) {
      textArea.setBackground(null);
    } else {
      textArea.setBackground(new Color(0xff, 0xcc, 0x60));
    }
    hasError = !success;
  }
  
  public boolean hasError() { return hasError; }
}
