/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.render;

import java.io.PrintStream;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviFontSpec;
import jp.sourceforge.dvibrowser.dvicore.api.DviExecutorContext;
import jp.sourceforge.dvibrowser.dvicore.api.DviExecutorHandler;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviBop;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviCommand;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPostPost;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPostamble;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPreamble;



public class DumpHandler
implements DviExecutorHandler
{
  private DviExecutorContext ctx;

  private final PrintStream out;
  public DumpHandler(PrintStream out)
  {
    this.out = out;
    if (out == null)
      throw new NullPointerException("output cannot be null");
  }
  
  public void begin(DviExecutorContext ctx) throws DviException {
    this.ctx = ctx;
  }
  public void end() throws DviException {
    ctx = null;
  }

  public void doSet(int code) throws DviException {
    dump("code=" + code);
  }
  public void doSetRule(int w, int h) throws DviException {
    dump("set_rule: w=" + w + " h=" + h);
  }
  public void doPut(int code) throws DviException {
    dump("code=" + code);
  }
  public void doPutRule(int w, int h) throws DviException {
    dump("put_rule: w=" + w + " h=" + h);
  }
  public void doNop() throws DviException {
    dump("");
  }

  public void doSelectFont(int fn) throws DviException {
    dump(": fn=" + fn);
  }
  public void doDefineFont(int fn, DviFontSpec fs) throws DviException {
    dump(": fn=" + fn + " fs=" + fs);
  }

  public void doPush() throws DviException {
    dump("");
  }
  public void doPop() throws DviException {
    dump("");
  }

  public void doPre(DviPreamble preamble) throws DviException {
    dump(preamble.toString());
  }
  public void doBop(DviBop bop) throws DviException {
    dump(bop.toString());
  }
  public void doEop() throws DviException {
    dump("");
  }
  public void doPost(DviPostamble postamble) throws DviException {
    dump(postamble.toString());
  }
  public void doPostPost(DviPostPost postPost) throws DviException {
    dump(postPost.toString());
  }

  public void doRight(int by) throws DviException {
    dump("dh=" + by);
  }
  public void doW(int by) throws DviException {
    dump("dh=" + by);
  }
  public void doW0() throws DviException {
    dump("");
  }
  public void doX(int by) throws DviException {
    dump("dh=" + by);
  }
  public void doX0() throws DviException {}

  public void doDown(int by) throws DviException {
    dump("dv=" + by);
  }
  public void doY(int by) throws DviException {
    dump("dv=" + by);
  }
  public void doY0() throws DviException {
    dump("");
  }
  public void doZ(int by) throws DviException {
    dump("dv=" + by);
  }
  public void doZ0() throws DviException {
    dump("");
  }

  public void doSpecial(byte [] xxx) throws DviException {
    dump(new String(xxx));
  }

  private void dump(String msg) {
    out.println(
      ctx.getCommandRange().toString()
      + ": " + DviCommand.getName(ctx.getCommand())
      + ": " + msg
    );
  }
}
