/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;

import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

import dvi.DviException;
import dvi.api.DviContext;
import dvi.ctx.DefaultDviContext;
import dvi.util.DviUtils;

public class DviBrowser
{
  private static final Logger LOGGER = Logger.getLogger(DviBrowser.class.getName());
	public static void startGUI(final String [] args) {
	  try {
	    try{
	      UIManager.getInstalledLookAndFeels();
	      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    }catch(Exception e) {e.printStackTrace();}
	    
	    Toolkit.getDefaultToolkit().setDynamicLayout(true);
	    
      DviContext ctx = new DefaultDviContext();
      final DviBrowserMain frame = new DviBrowserMain(ctx);
      frame.setSize(800, 600);
      frame.setLocationRelativeTo(null);
      frame.setVisible(true);
      frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
      SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          frame.open(args);
        }
      });
      LOGGER.info("dvibrowser start up.");
    } catch (DviException e) {
      DviUtils.logStackTrace(LOGGER, Level.SEVERE, e);
      LOGGER.info("dvibrowser shutdwon.");
      System.exit(1);
    }
	}
	
	public static void main(final String [] args) {
	  SwingUtilities.invokeLater(new Runnable() {
	    public void run() {
	      startGUI(args);
	    }
	  });
	}
}

