/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.DefaultListModel;

public class DviFileListModel
extends DefaultListModel
{
  private static final long serialVersionUID = 5283897963874660339L;
  private volatile List<File> list = new ArrayList<File>();
  private File dir;
  private FileFilter filter;
  
  public void setDirectory(final File dir)
  {
    this.dir = dir;
    updateFileList();
  }
  
  public void updateFileList()
  {
    List<File> newList = new ArrayList<File>();
    if (dir != null && dir.isDirectory()) {
      File [] list = dir.listFiles(filter);
      Arrays.sort(list);
      for (File f : list) {
        newList.add(f);
      }
    }
    int oldLen = list.size();
    int newLen = newList.size();
    list = newList;
    this.fireContentsChanged(this, 0, Math.max(newLen, oldLen));
  }
  
  public void notifyChange(int index)
  {
    this.fireContentsChanged(this, index, index);
  }
  
  @Override
  public int getSize() {
    return list.size();
  }

  @Override
  public Object getElementAt(int idx) {
    return list.get(idx);
  }

  public FileFilter getFilter()
  {
    return filter;
  }

  public void setFilter(FileFilter filter)
  {
    this.filter = filter;
  }
}
