package dvi.event;

public class TDefaultEventModel
implements TEventModel
{
  private volatile TEventListener listeners = null;

  public void addListener(TEventListener l)
  {
    listeners = TEventMulticaster.add(listeners, l);
  }

  public void addUniqueListener(TEventListener l)
  {
    removeListener(l);
    addListener(l);
  }

  public String dumpListeners()
  {
    if (listeners instanceof TEventMulticaster) {
      return ((TEventMulticaster) listeners).toString();
    } else if (listeners == null) {
      return "null";
    } else {
      return listeners.toString();
    }
  }

  public void removeListener(TEventListener l)
  {
    listeners = TEventMulticaster.remove(listeners, l);
  }

  public void removeListeners()
  {
    listeners = null;
  }

  public TEventListener getListeners()
  {
    return listeners;
  }

  public void inheritListeners(TEventProcessor ep)
  {
    if (ep == null) return;
    TEventModel em = ep.getEventModel();
    if (em == null) return;
    addListener(em.getListeners());
  }

  public void processEvent(TEvent e)
  {
    if (listeners != null)
      listeners.handleEvent(e);
  }
}
