/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.render;
import java.util.logging.Logger;

import dvi.DviObject;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviPage;
import dvi.ctx.DviToolkit;
import dvi.gui.swing.ViewSpec;
import dvi.util.concurrent.Computation;
import dvi.util.progress.ProgressItem;

public class DviPagePreparator
extends DviObject
implements Computation<String, Long> {
  private static final Logger LOGGER = Logger.getLogger(DviPagePreparator.class
      .getName());
  private final DviPage page;
  private final ViewSpec viewSpec;
  
  public DviPagePreparator(DviContextSupport dcs, DviPage page, ViewSpec viewSpec)
  {
    super(dcs);
    this.page = page;
    this.viewSpec = viewSpec;
  }

  public Long call() throws Exception
  {
    if (page == null) return -1L;
    final ProgressItem progress = getDviContext().getProgressRecorder().open("loading page " + (page.getPageNumber() + 1));
    try {
      long start = System.currentTimeMillis();
      LOGGER.finer("Start preparation of page " + page);
      ViewSpec dummyViewSpec = (ViewSpec) viewSpec.clone();
      DviResolution res = viewSpec.getResolution();
      dummyViewSpec.setResolution(res.approximate(10));
      DviToolkit utils = getDviContext().getDviToolkit();
      utils.renderToBufferedImage(page, null, dummyViewSpec);
      long end = System.currentTimeMillis();
      LOGGER.finer("Finished preparation of page " + page);
      LOGGER.finer("  Elapsed time = " + (end - start));
      return (end - start);
    } finally {
      progress.close();
    }
  }

  public String getCacheKey()
  {
    return page.getCacheKey();
  }

  public DviPage getPage()
  {
    return page;
  }

  public ViewSpec getViewSpec()
  {
    return viewSpec;
  }
}
