/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.special;

import dvi.api.DviContextSupport;
import dvi.render.BasicExecutor;

public abstract class AbstractDviSpecialExecutor
extends BasicExecutor
{
  public AbstractDviSpecialExecutor(DviContextSupport dcs) {
    super(dcs);
  }

  public boolean wantSet()        { return false; }
  public boolean wantPut()        { return false; }
  public boolean wantSelectFont() { return false; }
  public boolean wantSpecial()    { return true;  }
  public boolean wantSetRule()    { return false; }
  public boolean wantPutRule()    { return false; }
  public boolean wantDefineFont() { return false; }
  public boolean wantRight()      { return false; }
  public boolean wantW()          { return false; }
  public boolean wantW0()         { return false; }
  public boolean wantX()          { return false; }
  public boolean wantX0()         { return false; }
  public boolean wantDown()       { return false; }
  public boolean wantY()          { return false; }
  public boolean wantY0()         { return false; }
  public boolean wantZ()          { return false; }
  public boolean wantZ0()         { return false; }
  public boolean wantPush()       { return false; }
  public boolean wantPop()        { return false; }
  public boolean wantNop()        { return false; }
  public boolean wantBop()        { return false; }
  public boolean wantEop()        { return false; }
  public boolean wantPre()        { return false; }
  public boolean wantPost()       { return false; }
  public boolean wantPostPost()   { return false; }
}
