/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package dvi.v2.xdoc.dvi;

import java.awt.image.BufferedImage;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviPaperSize;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.DviSize;
import dvi.api.DviPage;
import dvi.image.split.DviImage;
import dvi.image.split.SplitImage;
import dvi.v2.xdoc.XDocument;
import dvi.v2.xdoc.XPage;

public class DviXPage
extends DviObject
implements XPage
{
  private static final Logger LOGGER = Logger.getLogger(DviXPage.class
      .getName());
  private final DviXDocument xdoc;
  private final DviPage page;

  public DviXPage(DviXDocument xdoc, DviPage page) {
    super(xdoc);
    this.xdoc = xdoc;
    this.page = page;
  }

  public DviRect getBoundingBox() throws DviException {
    return getDviContext().getDviToolkit().computeBoundingBox
      (getDviPage(), xdoc.getViewSpec().getResolution());
  }

  public XDocument getDocument() {
    return xdoc;
  }

  public int getPageNumber() throws DviException {
    return page.getPageNumber();
  }

  public DviPaperSize getPaperSize() throws DviException {
    return xdoc.getPaperSize();
  }

  public SplitImage getSplitImage(DviResolution res, DviRect target,
      DviSize unit) throws DviException {
    BufferedImage img = getDviContext().getDviToolkit().renderToBufferedImage
      (page, getBoundingBox(), xdoc.getViewSpec());
    DviImage img2 = new DviImage(img, (int) xdoc.getViewSpec().getResolution().actualDpi());
    return img2;
  }

  public DviPage getDviPage() {
    return page;
  }
}
