/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser;


import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.gui.swing.DviLayoutManager;

public class DviBoxBrowserPageLayout
extends AbstractDviBrowserPageLayout
{
  private static final Logger LOGGER = Logger.getLogger(DviBoxBrowserPageLayout.class.getName());
  
  private boolean fitToWidth;
  private boolean fitToHeight;
  private double minimumDpi = 16;
  
  public DviBoxBrowserPageLayout(DviContextSupport dcs, String name, boolean fitToWidth, boolean fitToHeight) {
    super(dcs, name);
    this.setFitToHeight(fitToHeight);
    this.setFitToWidth(fitToWidth);
  }
  
  public void layoutDviBrowserPage(DviBrowserPage browserPage, DviDocument doc)
      throws DviException
  {
    Dimension viewportSize = browserPage.getViewportSize();
    DviResolution or = browserPage.getViewSpec().getResolution();
    DviLayoutManager layout = browserPage.getTDviDocument().getDviLayout();
    Point pos = browserPage.getScrollPane().getViewport().getViewPosition();
    int sf = 1;
    DviResolution nr = null;
    do {
      nr = new DviResolution(or.dpi(), sf);
      DviRect pageBbox = browserPage.getTDviDocument().getDviLayout().getPageBoundingBox(doc, nr);
      DviRect bbox = layout.getBoundingBox(doc, nr);
      boolean success = true;
      if (fitToWidth) {
        if (!(bbox.width() < viewportSize.width)) {
          success = false;
        }
      }
      if (fitToHeight) {
        if (!(pageBbox.height() < viewportSize.height)) {
          success = false;
        }
      }
      if (success) break;
      sf++;
    } while (sf < DviResolution.MAX_SHRINK_FACTOR && nr.actualDpi() > minimumDpi);
        
//    int nx = (int) ((double) pos.x * or.shrinkFactor() / nr.shrinkFactor());
    int ny = (int) ((double) pos.y * or.shrinkFactor() / nr.shrinkFactor());
//    nx = Math.max(0, nx);
    ny = Math.max(0, ny);
    LOGGER.fine("setting the resolution to " + nr);
    browserPage.getViewSpec().setResolution(nr);
    browserPage.getScrollPane().getViewport().setViewPosition(new Point(0, ny));
  }

  public void setFitToWidth(boolean fitToWidth)
  {
    this.fitToWidth = fitToWidth;
  }

  public boolean getFitToWidth()
  {
    return fitToWidth;
  }

  public void setFitToHeight(boolean fitToHeight)
  {
    this.fitToHeight = fitToHeight;
  }

  public boolean getFitToHeight()
  {
    return fitToHeight;
  }

  public void setMinimumDpi(double minimumDpi)
  {
    this.minimumDpi = minimumDpi;
  }

  public double getMinimumDpi()
  {
    return minimumDpi;
  }
}
