/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;

public class DviFileWatchTarget
extends FileWatch.Target
implements DviContextSupport
{
  private static final Logger LOGGER = Logger.getLogger(DviFileWatchTarget.class.getName());
  private final DviContext ctx;
  
  public DviFileWatchTarget(DviContextSupport dcs, File file)
  throws IOException
  {
    super(file);
    this.ctx = dcs.getDviContext();
  }
  
  protected boolean isContentReady(File file)
  {
    try {
      DviDocument doc = ctx.openDviDocument(file);
      LOGGER.config("Checking modified file: " + file);
      if (doc == null) {
        LOGGER.config("Unable to parse document.  We will retry later.");
        return false;
      }
    } catch (DviException ex) {
      LOGGER.config("File seems to be under modification.  We will retry later.");
      return false;
    }
    LOGGER.config("File is ready: " + file);
    return true;
  }

  public DviContext getDviContext()
  {
    return ctx;
  }
}
