/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi;

import java.awt.Point;

// immutable.

public final class DviPoint
implements java.io.Serializable
{
  private static final long serialVersionUID = 5621339308791022419L;

  public static final DviPoint ORIGIN = new DviPoint(0,0);

  public final int x;
  public final int y;

  public DviPoint(int x, int y) {
    this.x = x;
    this.y = y;
  }

  public DviPoint(DviPoint orig) {
    this(orig.x, orig.y);
  }

  public DviPoint translate(DviPoint p) {
    return new DviPoint(x + p.x, y + p.y);
  }
  public DviPoint translate(int dx, int dy) {
    return new DviPoint(x + dx, y + dy);
  }

  public DviPoint shrink(int f) {
    if (f <= 0)
      throw new IllegalArgumentException
        ("shrink factor can't be <= 0.");

    return new DviPoint(
      flooredDivision(x, f),
      flooredDivision(y, f)
    );
  }

  public DviPoint magnify(int f) {
    return new DviPoint(x * f, y * f);
  }

  private static int flooredDivision(int a, int b) {
    return (a < 0) ? (a - b + 1) / b : a / b;
  }


  public int hashCode() {
    return x + 33*y;
  }

  public boolean equals(Object obj) {
    if (obj instanceof DviPoint) {
      DviPoint p = (DviPoint) obj;
      return p.x == x && p.y == y;
    }
    return false;
  }

  public String toString() {
    return "(" + x + "," + y + ")";
  }

}
