/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.render;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.api.DviExecutorContext;
import dvi.api.DviExecutorHandler;
import dvi.cmd.DviBop;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;

public class StopHandler
implements DviExecutorHandler
{
  private DviExecutorContext ctx;
  public void begin(DviExecutorContext ctx) throws DviException {
    this.ctx = ctx;
  }
  public void end() throws DviException { ctx = null; }

  public void doSet(int code) throws DviException {
    ctx.setTerminate(true);
  }
  public void doSetRule(int w, int h) throws DviException {
    ctx.setTerminate(true);
  }
  public void doPut(int code) throws DviException {
    ctx.setTerminate(true);
  }
  public void doPutRule(int w, int h) throws DviException {
    ctx.setTerminate(true);
  }
  public void doNop() throws DviException {
    ctx.setTerminate(true);
  }

  public void doSelectFont(int fn) throws DviException {
    ctx.setTerminate(true);
  }
  public void doDefineFont(int fn, DviFontSpec fs) throws DviException {
    ctx.setTerminate(true);
  }

  public void doPush() throws DviException {
    ctx.setTerminate(true);
  }
  public void doPop() throws DviException {
    ctx.setTerminate(true);
  }

  public void doPre(DviPreamble preamble) throws DviException {
    ctx.setTerminate(true);
  }
  public void doBop(DviBop bop) throws DviException {
    ctx.setTerminate(true);
  }
  public void doEop() throws DviException {
    ctx.setTerminate(true);
  }
  public void doPost(DviPostamble postamble) throws DviException {
    ctx.setTerminate(true);
  }
  public void doPostPost(DviPostPost postPost) throws DviException {
    ctx.setTerminate(true);
  }

  public void doRight(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doW(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doW0() throws DviException {
    ctx.setTerminate(true);
  }
  public void doX(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doX0() throws DviException {
    ctx.setTerminate(true);
  }

  public void doDown(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doY(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doY0() throws DviException {
    ctx.setTerminate(true);
  }
  public void doZ(int by) throws DviException {
    ctx.setTerminate(true);
  }
  public void doZ0() throws DviException {
    ctx.setTerminate(true);
  }

  public void doSpecial(byte [] xxx) throws DviException {
    ctx.setTerminate(true);
  }
}
