/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.special;

import dvi.DviByteRange;

public class Anchor
extends DviByteRange
{
  public Anchor(long begin, long end) {
    super(begin, end);
  }

  public static class StringValued
  extends Anchor
  {
    private String str;

    public StringValued(long begin, long end, String str) {
      super(begin, end);
      this.str = str;
    }
    public String string() { return str; }

    public String toString() {
      return getClass().getName()
        + "[range=" + super.toString()
        + ",str=" + str
        + "]";
    }
  }

  public static class Href
  extends StringValued
  {
    public Href(long begin, long end, String str) {
      super(begin, end, str);
    }
    public String getLocation() { return string(); }
  }

  public static class Name
  extends StringValued
  {
    public Name(long begin, long end, String str) {
      super(begin, end, str);
    }
    public String name() { return string(); }
  }
  
  public static class Source
  extends StringValued
  {
    private final int lineNumber;
    public Source(long begin, long end, String str, int lineNumber) {
      super(begin, end, str);
      this.lineNumber = lineNumber;
    }
    public String getFilename() { return string(); }
    public int getLineNumber()
    {
      return lineNumber;
    }
    public String toString() {
      return getClass().getName()
        + "[range=" + super.toString()
        + ",filename=" + string()
        + ",lineNumber=" + lineNumber
        + "]";
    }
  }
}
