/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
public class LineBuffer<T> {
  public static final int BUFFER_UNLIMITED = -1;
  private int maxLineNumbers;
  private final ArrayList<T> list = new ArrayList<T>();
  
  public LineBuffer()
  {
    this(BUFFER_UNLIMITED);
  }
  
  public LineBuffer(int maxLineNumbers)
  {
    this.setMaxLineNumbers(maxLineNumbers);
  }
  
  public void append(T line)
  {
    list.add(line);
    if (isBufferLimited()) {
      while (list.size() > maxLineNumbers) {
        list.remove(0);
      }
    }
  }
  
  private boolean isBufferLimited() {
    return !(maxLineNumbers == BUFFER_UNLIMITED);
  }

  public List<T> toList() {
    return Collections.unmodifiableList(list);
  }

  public int getMaxLineNumbers() {
    return maxLineNumbers;
  }

  public void setMaxLineNumbers(int maxLineNumbers) {
    if (maxLineNumbers < 0) {
      this.maxLineNumbers = BUFFER_UNLIMITED;
    } else {
      this.maxLineNumbers = maxLineNumbers;
    }
  }

  public String toString()
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getClass().getName()
      + "["
      + "maxLineNumbers=" + maxLineNumbers
      + "numLines=" + list.size()
      + "lines=" + DviUtils.join("[", ",", "]", list.toArray())
      + "]"
      );
    return sb.toString();
  }
}
