/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.browser.v2.list;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviRect;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.gui.swing.ViewSpec;
import dvi.util.DviUtils;

public class DviPageCellRenderer
extends DviObject
implements ListCellRenderer
{
  private static final Logger LOGGER = Logger
  .getLogger(DviPageCellRenderer.class.getName());
  
  private ViewSpec viewSpec = new ViewSpec(this);

  public DviPageCellRenderer(DviContextSupport dcs) {
    super(dcs);
  }

  private final JLabel label = new JLabel();
  public Component getListCellRendererComponent(final JList list, Object value,
      int index, boolean isSelected, boolean cellHasFocus) {
    if (value instanceof DviPage) {
      final DviPage page = (DviPage) value;
      final DviPageIcon icon = new DviPageIcon(this, page, getPageBoundingBox(page), viewSpec);
      label.setIcon(icon);
      if (isSelected) {
        label.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, new Color(20, 80, 250)));
      } else {
        label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(190, 190, 190)));
      }
      return label;
    } else {
      LOGGER.warning("Unsupported list value type: " + value);
    }
    return null;
  }

  private DviRect bbox = null;
  private DviRect getPageBoundingBox(DviPage page) {
    if (bbox == null) {
      try {
        DviDocument doc = page.getDocument();
        bbox = DviRect.union(getDviContext().getDviToolkit().computeBoundingBoxes(doc, viewSpec.getResolution()));
      } catch (DviException e) {
        DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
      }
    }
    return bbox;
  }

  public ViewSpec getViewSpec() {
    return viewSpec;
  }

  public void setViewSpec(ViewSpec viewSpec) {
    this.viewSpec = viewSpec;
  }
}
